/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.tooltip;

import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class TooltipDecor {
    public static final ResourceLocation DEFAULT_BORDERS = ResourceLocation.fromNamespaceAndPath((String)"legendarytooltips", (String)"textures/gui/tooltip_borders.png");
    static int currentTooltipBorderStart = 0;
    static int currentTooltipBorderEnd = 0;
    static int currentTooltipBackgroundStart = 0;
    static int currentTooltipBackgroundEnd = 0;
    private static float shineTimer = 2.5f;

    public static void setCurrentTooltipBorderStart(int color) {
        currentTooltipBorderStart = color;
    }

    public static void setCurrentTooltipBorderEnd(int color) {
        currentTooltipBorderEnd = color;
    }

    public static void setCurrentTooltipBackgroundStart(int color) {
        currentTooltipBackgroundStart = color;
    }

    public static void setCurrentTooltipBackgroundEnd(int color) {
        currentTooltipBackgroundEnd = color;
    }

    public static void updateTimer(float deltaTime) {
        if (shineTimer > 0.0f) {
            shineTimer -= deltaTime;
        }
    }

    public static void resetTimer() {
        shineTimer = 2.5f;
    }

    public static void drawShadow(PoseStack poseStack, int x, int y, int width, int height) {
        int shadowColor = 0x44000000;
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x - 1), (int)(y + height + 4), (int)(x + width + 4), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 4), (int)(y - 1), (int)(x + width + 5), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 3), (int)(y + height + 3), (int)(x + width + 4), (int)(y + height + 4), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)x, (int)(y + height + 5), (int)(x + width + 5), (int)(y + height + 6), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 5), (int)y, (int)(x + width + 6), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        poseStack.popPose();
    }

    public static void drawSeparator(PoseStack poseStack, int x, int y, int width, int color) {
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)x, (int)y, (int)(x + width / 2), (int)(y + 1), (int)(color & 0xFFFFFF), (int)color);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)(x + width / 2), (int)y, (int)(x + width), (int)(y + 1), (int)color, (int)(color & 0xFFFFFF));
        poseStack.popPose();
    }

    public static void drawBorder(PoseStack poseStack, int x, int y, int width, int height, ItemStack item, List<ClientTooltipComponent> components, Font font, LegendaryTooltipsConfig.FrameDefinition frameDefinition, boolean comparison, int index) {
        Matrix4f matrix;
        if (comparison) {
            poseStack.pushPose();
            matrix = poseStack.last().pose();
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderStart);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)currentTooltipBorderEnd, (int)currentTooltipBorderEnd);
            poseStack.popPose();
            TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 1 + 10, width, currentTooltipBorderStart);
        }
        if (LegendaryTooltipsConfig.getInstance().nameSeparator.get().booleanValue() && item != null && !item.isEmpty() && frameDefinition.index() != -2) {
            int titleLines = Tooltips.calculateTitleLines(components);
            int numComponents = components.size();
            for (int i = 0; i < components.size() && (components.get(i) instanceof ClientTextTooltip || --numComponents != titleLines); ++i) {
            }
            if (titleLines < numComponents) {
                int i;
                int offset = 0;
                int titleStart = 0;
                if (LegendaryTooltipsConfig.showModelForItem(item)) {
                    offset += 7;
                }
                for (i = 0; i < components.size(); ++i) {
                    if (!(components.get(i) instanceof ClientTextTooltip)) continue;
                    titleStart = i;
                    break;
                }
                for (i = 0; i < titleStart + titleLines && i < components.size(); ++i) {
                    ClientTooltipComponent component = components.get(i);
                    if (component instanceof ClientTextTooltip) {
                        int n = component.getHeight();
                        Objects.requireNonNull(font);
                        offset += Math.max(n, 9);
                        continue;
                    }
                    offset += component.getHeight();
                    if (i > titleStart) continue;
                    offset += 2;
                }
                if (comparison) {
                    offset += 11;
                }
                TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 2 + offset, width, currentTooltipBorderStart);
            }
        }
        if (frameDefinition.index() == -1) {
            return;
        }
        if (LegendaryTooltipsConfig.getInstance().shineEffect.get().booleanValue()) {
            int alpha;
            poseStack.pushPose();
            matrix = poseStack.last().pose();
            if (shineTimer >= 0.5f && shineTimer <= 2.0f) {
                float interval = Mth.clamp((float)(shineTimer - 0.5f), (float)0.0f, (float)1.0f);
                alpha = (int)(153.0f * interval) << 24;
                int horizontalMin = x - 3;
                int horizontalMax = x + width + 3;
                int horizontalInterval = (int)Mth.lerp((float)(interval * interval), (float)horizontalMax, (float)horizontalMin);
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)Math.max(horizontalInterval - 36, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval, horizontalMax), (int)(y - 3 + 1), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)402, (int)Math.max(horizontalInterval, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval + 36, horizontalMax), (int)(y - 3 + 1), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            if (shineTimer <= 1.0f) {
                float interval = Mth.clamp((float)shineTimer, (float)0.0f, (float)1.0f);
                alpha = (int)(85.0f * interval) << 24;
                int verticalMin = y - 3 + 1;
                int verticalMax = y + height + 3 - 1;
                int verticalInterval = (int)Mth.lerp((float)(interval * interval), (float)verticalMax, (float)verticalMin);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)402, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)402, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            poseStack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)frameDefinition.resource());
        Minecraft minecraft = Minecraft.getInstance();
        AbstractTexture borderTexture = minecraft.getTextureManager().getTexture(frameDefinition.resource());
        borderTexture.bind();
        int textureWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int textureHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        int frameIndex = frameDefinition.index();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 410.0);
        GuiHelper.blit((PoseStack)poseStack, (int)(x - 6), (int)(y - 6), (int)8, (int)8, (float)(frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y - 6), (int)8, (int)8, (float)(56 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x - 6), (int)(y + height - 8 + 6), (int)8, (int)8, (float)(frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y + height - 8 + 6), (int)8, (int)8, (float)(56 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        if (width >= 48) {
            GuiHelper.blit((PoseStack)poseStack, (int)(x + width / 2 - 24), (int)(y - 9), (int)48, (int)8, (float)(8 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
            GuiHelper.blit((PoseStack)poseStack, (int)(x + width / 2 - 24), (int)(y + height - 8 + 9), (int)48, (int)8, (float)(8 + frameIndex / 8 * 64), (float)(frameIndex * 16 % textureHeight + 8), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
        }
        poseStack.popPose();
    }
}

