/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.mixin;

import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1001)
public class GuiGraphicsMixin {
    @ModifyVariable(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, ordinal=0, at=@At(value="LOAD", ordinal=0), argsOnly=true)
    private List<ClientTooltipComponent> mutableComponents(List<ClientTooltipComponent> components) {
        if (LegendaryTooltipsConfig.getInstance().centeredTitle.get().booleanValue()) {
            return new ArrayList<ClientTooltipComponent>(components);
        }
        return components;
    }

    @ModifyVariable(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, ordinal=2, at=@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0))
    private int setMinimumWidth(int width) {
        if (LegendaryTooltipsConfig.getInstance().enforceMinimumWidth.get().booleanValue()) {
            return Math.max(width, 48);
        }
        return width;
    }

    @Inject(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0)})
    private void centerTitle(Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info) {
        if (!components.isEmpty() && font != null && LegendaryTooltipsConfig.getInstance().centeredTitle.get().booleanValue()) {
            int tooltipWidth = 0;
            if (LegendaryTooltipsConfig.getInstance().enforceMinimumWidth.get().booleanValue()) {
                tooltipWidth = 48;
            }
            tooltipWidth = new Tooltips.TooltipInfo(components, font, 1).getMaxLineWidth(tooltipWidth);
            List centeredComponents = Tooltips.centerTitle(components, (Font)font, (int)tooltipWidth, (int)Tooltips.calculateTitleLines(components));
            components.clear();
            components.addAll(centeredComponents);
        }
    }
}

