/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.config;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.anthonyhilyard.prism.util.IColor;
import com.anthonyhilyard.prism.util.ImageAnalysis;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class LegendaryTooltipsConfig
extends IcebergConfig<LegendaryTooltipsConfig> {
    private static final FrameDefinition STANDARD_BORDER = new FrameDefinition(null, -1, null, null, null, null, FrameSource.NONE, 0);
    private static final FrameDefinition NO_BORDER = new FrameDefinition(null, -2, null, null, null, null, FrameSource.NONE, 0);
    public static final Map<ColorType, TextColor> defaultColors = Map.of(ColorType.BORDER_START, TextColor.fromRgb((int)-6723294), ColorType.BORDER_END, TextColor.fromRgb((int)-10864099), ColorType.BG_START, TextColor.fromRgb((int)-266991104), ColorType.BG_END, TextColor.fromRgb((int)-401208832));
    public final Supplier<Boolean> nameSeparator;
    public final Supplier<Boolean> bordersMatchRarity;
    public final Supplier<Boolean> tooltipShadow;
    public final Supplier<Boolean> shineEffect;
    public final Supplier<Boolean> centeredTitle;
    public final Supplier<Boolean> enforceMinimumWidth;
    public final Supplier<Boolean> compactTooltips;
    public final Supplier<ModelRenderType> renderItemModel;
    public final Supplier<Double> modelRotationSpeed;
    final TextColor[] startColors = new TextColor[16];
    final TextColor[] endColors = new TextColor[16];
    private final TextColor[] startBGColors = new TextColor[16];
    private final TextColor[] endBGColors = new TextColor[16];
    final Supplier<List<? extends Integer>> framePriorities;
    static final List<Supplier<List<? extends String>>> itemSelectors = new ArrayList<Supplier<List<? extends String>>>(16);
    private final Supplier<List<? extends String>> blacklist;
    private static final Map<FrameDefinition, Set<String>> customFrameDefinitions = new LinkedHashMap<FrameDefinition, Set<String>>();
    private static final Map<ItemStack, FrameDefinition> frameDefinitionCache = new HashMap<ItemStack, FrameDefinition>();
    private static final Map<FormattedText, FormattedText> formattedTitleCache = new HashMap<FormattedText, FormattedText>();
    private static final List<Supplier<Supplier<?>>> colorSuppliers = new ArrayList();

    public static LegendaryTooltipsConfig getInstance() {
        return (LegendaryTooltipsConfig)((Object)configInstances.get("legendarytooltips"));
    }

    public LegendaryTooltipsConfig(IIcebergConfigSpecBuilder build) {
        build.comment(" Legendary Tooltips Configuration Instructions\n\n *** READ THIS FIRST ***\n\n By default, this mod does not apply special borders to most items.  It was designed to work well with mod packs where\n the available selection of items can vary widely, so it is up to the user or mod pack designer to customize as needed.\n There are many options available for setting up which custom borders (also called frames) apply to which items.  Follow these steps:\n   1. Decide which items you want to have custom borders, and which borders.  Note that each custom border has a number associated with it (starting at 0).\n   2. For each custom border you want to use, fill out the associated list in the \"definitions\" section.  This will be filled out with a list of \"selectors\",\n      each of which tell the mod what items have that border.  Please read the information above the definitions section for specifics.\n   3. Selectors for borders are checked in the order provided in the \"priorities\" section.  Once a match is found, that border is displayed.\n      For example, if border 0 had the selector \"%Diamond\" and border 1 had the selector \"diamond_sword\", they would both match for diamond swords.\n      In this case, whichever border number came first in the priority list would be the border that would get drawn in-game.\n   4. Optionally, border colors associated with custom borders can be set in the \"colors\" section.  The start color is the color at the top of the tooltip,\n      and the end color is the bottom, with a smooth transition between.  Please read the information above the color section for specifics.").push("client").push("visual_options");
        this.nameSeparator = build.comment(" Whether item names in tooltips should have a line under them separating them from the rest of the tooltip.").add("name_separator", true);
        this.bordersMatchRarity = build.comment(" If enabled, tooltip border colors will match item rarity colors (except for custom borders).").add("borders_match_rarity", true);
        this.tooltipShadow = build.comment(" If enabled, tooltips will display a drop shadow.").add("tooltip_shadow", true);
        this.shineEffect = build.comment(" If enabled, items showing a custom border will have a special shine effect when hovered over.").add("shine_effect", true);
        this.centeredTitle = build.comment(" If enabled, tooltip titles will be drawn centered.").add("centered_title", true);
        this.enforceMinimumWidth = build.comment(" If enabled, tooltips with custom borders will always be at least wide enough to display all border decorations.").add("enforce_minimum_width", false);
        this.compactTooltips = build.comment(" If enabled, some unnecessary text and spacing will be removed from equipment tooltips.").add("compact_tooltips", true);
        this.renderItemModel = build.comment(" Which items should have a 3D model rendered in the tooltip.  If set to \"equipment\", the model will only be rendered for items with durability.").addEnum("render_item_model", (Enum)ModelRenderType.EQUIPMENT);
        this.modelRotationSpeed = build.comment(" The speed at which 3D models in tooltips will rotate.  Lower values rotate faster, set to 0 to disable rotation.").addInRange("model_rotation_speed", 12.0, 0.0, 50.0);
        build.pop().comment(String.format(" Custom borders are broken into %d \"levels\", with level 0 being intended for the \"best\" or \"rarest\" items. Only level 0 has a custom border built-in, but others can be added with resource packs.", 16)).push("custom_borders");
        StringBuilder selectorsComment = new StringBuilder(" Entry types:\n");
        for (Object doc : Selectors.selectorDocumentation()) {
            selectorsComment.append("    ").append(doc.name()).append(" - ").append(doc.description());
            if (!doc.examples().isEmpty()) {
                selectorsComment.append("  Examples: ");
                for (int i = 0; i < doc.examples().size(); ++i) {
                    if (i > 0) {
                        selectorsComment.append(", ");
                    }
                    selectorsComment.append("\"").append((String)doc.examples().get(i)).append("\"");
                }
            }
            selectorsComment.append("\n");
        }
        selectorsComment.setLength(selectorsComment.length() - 1);
        build.pop().comment(selectorsComment.toString());
        build.push("definitions");
        itemSelectors.clear();
        itemSelectors.add(build.addListAllowEmpty("level0_entries", Arrays.asList("!epic", "!rare"), e -> Selectors.validateSelector((String)((String)e))));
        for (int i = 1; i < 16; ++i) {
            itemSelectors.add(build.addListAllowEmpty(String.format("level%d_entries", i), (List)Lists.newArrayList(), e -> Selectors.validateSelector((String)((String)e))));
        }
        this.blacklist = build.comment(" Enter blacklist selectors here using the same format as above. Any items that match these selectors will NOT show a border.").addListAllowEmpty("blacklist", Arrays.asList(new String[0]), e -> Selectors.validateSelector((String)((String)e)));
        build.pop().comment(" Set border priorities here.  This should be a list of numbers that correspond to border levels, with numbers coming first being higher priority.\n Optionally, -1 can be inserted to indicate relative priority of data and api-defined borders.  If you don't know what that means, you don't need to worry about it.").push("priorities");
        this.framePriorities = build.addList("priorities", IntStream.rangeClosed(0, 15).boxed().collect(Collectors.toList()), e -> (Integer)e >= -1 && (Integer)e < 16);
        StringBuilder colorFormatsComment = new StringBuilder(" VALID COLOR FORMATS\n");
        for (ConfigHelper.ColorFormatDocumentation doc : ConfigHelper.colorFormatDocumentation()) {
            colorFormatsComment.append("   ").append(doc.name()).append(" - ").append(doc.description().replace("\n", "\n         "));
            if (!doc.examples().isEmpty()) {
                colorFormatsComment.append("\n     Examples: ");
                for (int i = 0; i < doc.examples().size(); ++i) {
                    if (i > 0) {
                        colorFormatsComment.append(", ");
                    }
                    colorFormatsComment.append((String)doc.examples().get(i));
                }
            }
            colorFormatsComment.append("\n\n");
        }
        colorFormatsComment.setLength(colorFormatsComment.length() - 2);
        build.pop().comment(" The colors used for each tooltip, in this order: top border color, bottom border color, top background color, bottom background color.\n None of these colors are required, though any colors not specified will be replaced with the default tooltip colors.\n\n" + colorFormatsComment.toString()).push("colors");
        colorSuppliers.clear();
        for (int i = 0; i < 16; ++i) {
            Supplier colorsValue = build.addList(String.format("level%d_colors", i), i == 0 ? List.of(Integer.valueOf(defaultColors.get((Object)ColorType.BORDER_START).getValue()), Integer.valueOf(defaultColors.get((Object)ColorType.BORDER_END).getValue()), Integer.valueOf(defaultColors.get((Object)ColorType.BG_START).getValue()), Integer.valueOf(defaultColors.get((Object)ColorType.BG_END).getValue())) : List.of("auto", "auto", "auto", "auto"), v -> LegendaryTooltipsConfig.validateColor(v));
            colorSuppliers.add(() -> LegendaryTooltipsConfig.lambda$new$5((Supplier)colorsValue));
        }
        build.pop().pop();
    }

    public static boolean showModelForItem(ItemStack itemStack) {
        switch (LegendaryTooltipsConfig.getInstance().renderItemModel.get().ordinal()) {
            default: {
                return false;
            }
            case 2: {
                return !itemStack.isEmpty();
            }
            case 1: 
        }
        return !itemStack.isEmpty() && itemStack.isDamageableItem();
    }

    private static FormattedCharSequence getTitlePadding(Font font, int maxWidth) {
        Object pad = " ";
        while (font.width((String)pad) < maxWidth) {
            pad = (String)pad + " ";
        }
        return FormattedCharSequence.forward((String)pad, (Style)Style.EMPTY);
    }

    private static Font getFontForTitle(FormattedText title) {
        Font result = null;
        Minecraft minecraft = Minecraft.getInstance();
        result = minecraft.screen != null && minecraft.screen.font != null && minecraft.screen.font != minecraft.font ? minecraft.screen.font : minecraft.font;
        return result;
    }

    public static FormattedText getFormattedTitle(FormattedText title) {
        Font font;
        FormattedCharSequence paddedTitle;
        List recomposedTitle;
        if (!formattedTitleCache.containsKey(title) && !(recomposedTitle = StringRecomposer.recompose(List.of(ClientTooltipComponent.create((FormattedCharSequence)(paddedTitle = FormattedCharSequence.fromList(List.of(LegendaryTooltipsConfig.getTitlePadding(font = LegendaryTooltipsConfig.getFontForTitle(title), 24), Language.getInstance().getVisualOrder(title), LegendaryTooltipsConfig.getTitlePadding(font, 4)))))))).isEmpty()) {
            formattedTitleCache.put(title, (FormattedText)recomposedTitle.get(0));
        }
        return formattedTitleCache.get(title);
    }

    public static TextColor getColor(Object value) {
        return LegendaryTooltipsConfig.getColor(value, null, null, 0, null);
    }

    public static TextColor getColor(Object value, TextColor defaultColor, ResourceLocation borderImage, int index, ColorType colorType) {
        TextColor color = (TextColor)ConfigHelper.parseColor((Object)value);
        if (color == null) {
            String string;
            if (value instanceof String && (string = (String)value).contentEquals("auto") && borderImage != null) {
                Rect2i region = new Rect2i(index / 8 * 64, index * 16 % 128, 64, 16);
                switch (colorType.ordinal()) {
                    case 0: {
                        region.setHeight(8);
                        break;
                    }
                    case 1: {
                        region.setHeight(8);
                        region.setY(region.getY() + 8);
                        break;
                    }
                }
                color = ImageAnalysis.getDominantColor((ResourceLocation)borderImage, (Rect2i)region);
                if (color == null) {
                    return defaultColor;
                }
                switch (colorType.ordinal()) {
                    case 0: {
                        if (DynamicColor.fromColor((IColor)((IColor)color)).value() > 80 && DynamicColor.fromColor((IColor)((IColor)(color = ConfigHelper.applyModifiers(List.of("-v10", "+s10"), (TextColor)color)))).value() > 200) {
                            color = ConfigHelper.applyModifiers(List.of("-v10"), (TextColor)color);
                        }
                        if (DynamicColor.fromColor((IColor)((IColor)color)).saturation() <= 40) break;
                        color = ConfigHelper.applyModifiers(List.of("+s10"), (TextColor)color);
                        break;
                    }
                    case 1: {
                        if (DynamicColor.fromColor((IColor)((IColor)color)).value() > 80 && DynamicColor.fromColor((IColor)((IColor)(color = ConfigHelper.applyModifiers(List.of("-v30"), (TextColor)color)))).value() > 170 && DynamicColor.fromColor((IColor)((IColor)color)).value() < 220) {
                            color = ConfigHelper.applyModifiers(List.of("-v30"), (TextColor)color);
                        }
                        if (DynamicColor.fromColor((IColor)((IColor)color)).saturation() <= 40) break;
                        color = ConfigHelper.applyModifiers(List.of("+s50"), (TextColor)color);
                        break;
                    }
                    case 2: {
                        color = ConfigHelper.applyModifiers(List.of("=v8", "+s50", "=a245"), (TextColor)color);
                        break;
                    }
                    case 3: {
                        color = ConfigHelper.applyModifiers(List.of("=v20", "+s75", "=a230"), (TextColor)color);
                    }
                }
                if (color != null) {
                    return color;
                }
            }
            return defaultColor;
        }
        return color;
    }

    private static boolean validateColor(Object value) {
        String string;
        return LegendaryTooltipsConfig.getColor(value) != null || value instanceof String && (string = (String)value).contentEquals("auto");
    }

    private static void resolveColors() {
        for (int i = 0; i < 16; ++i) {
            Object colors = colorSuppliers.get(i).get().get();
            if (colors instanceof List) {
                List colorsList = (List)colors;
                LegendaryTooltipsConfig.getInstance().startColors[i] = LegendaryTooltipsConfig.getColor(colorsList.size() > 0 ? colorsList.get(0) : null, defaultColors.get((Object)ColorType.BORDER_START), TooltipDecor.DEFAULT_BORDERS, i, ColorType.BORDER_START);
                LegendaryTooltipsConfig.getInstance().endColors[i] = LegendaryTooltipsConfig.getColor(colorsList.size() > 1 ? colorsList.get(1) : null, defaultColors.get((Object)ColorType.BORDER_END), TooltipDecor.DEFAULT_BORDERS, i, ColorType.BORDER_END);
                LegendaryTooltipsConfig.getInstance().startBGColors[i] = LegendaryTooltipsConfig.getColor(colorsList.size() > 2 ? colorsList.get(2) : null, defaultColors.get((Object)ColorType.BG_START), TooltipDecor.DEFAULT_BORDERS, i, ColorType.BG_START);
                LegendaryTooltipsConfig.getInstance().endBGColors[i] = LegendaryTooltipsConfig.getColor(colorsList.size() > 3 ? colorsList.get(3) : null, defaultColors.get((Object)ColorType.BG_END), TooltipDecor.DEFAULT_BORDERS, i, ColorType.BG_END);
                continue;
            }
            LegendaryTooltipsConfig.getInstance().startColors[i] = defaultColors.get((Object)ColorType.BORDER_START);
            LegendaryTooltipsConfig.getInstance().endColors[i] = defaultColors.get((Object)ColorType.BORDER_END);
            LegendaryTooltipsConfig.getInstance().startBGColors[i] = defaultColors.get((Object)ColorType.BG_START);
            LegendaryTooltipsConfig.getInstance().endBGColors[i] = defaultColors.get((Object)ColorType.BG_END);
        }
    }

    public void addFrameDefinition(ResourceLocation resource, int index, Supplier<Integer> startBorder, Supplier<Integer> endBorder, Supplier<Integer> background, int priority, List<String> selectors) {
        this.addFrameDefinition(resource, index, startBorder, endBorder, background, background, priority, selectors);
    }

    public void addFrameDefinition(ResourceLocation resource, int index, Supplier<Integer> startBorder, Supplier<Integer> endBorder, Supplier<Integer> startBackground, Supplier<Integer> endBackground, int priority, List<String> selectors) {
        FrameDefinition definition = new FrameDefinition(resource, index, startBorder, endBorder, startBackground, endBackground, FrameSource.API, priority);
        this.addFrameDefinition(definition, selectors);
    }

    void addFrameDefinition(FrameDefinition definition, List<String> selectors) {
        if (definition.source != FrameSource.API && definition.source != FrameSource.DATA) {
            return;
        }
        LinkedHashSet<String> selectorSet = new LinkedHashSet<String>();
        if (customFrameDefinitions.containsKey(definition)) {
            selectorSet.addAll((Collection)customFrameDefinitions.get(definition));
        }
        selectorSet.addAll(selectors);
        customFrameDefinitions.put(definition, selectorSet);
    }

    void clearDataFrames() {
        customFrameDefinitions.entrySet().removeIf(entry -> ((FrameDefinition)entry.getKey()).source == FrameSource.DATA);
    }

    /*
     * WARNING - void declaration
     */
    public FrameDefinition getFrameDefinition(ItemStack item, HolderLookup.Provider provider) {
        void var4_6;
        if (frameDefinitionCache.containsKey(item)) {
            return frameDefinitionCache.get(item);
        }
        if (item == null) {
            frameDefinitionCache.put(item, STANDARD_BORDER);
            return STANDARD_BORDER;
        }
        if (this.startColors[0] == null) {
            LegendaryTooltipsConfig.resolveColors();
        }
        for (String string : this.blacklist.get()) {
            if (!Selectors.itemMatches((ItemStack)item, (String)string, (HolderLookup.Provider)provider)) continue;
            frameDefinitionCache.put(item, NO_BORDER);
            return NO_BORDER;
        }
        List priorities = this.framePriorities.get().stream().map(i -> (int)i).collect(Collectors.toCollection(ArrayList::new));
        if (!priorities.contains(-1)) {
            priorities.add(0, -1);
        }
        boolean bl = false;
        while (var4_6 < priorities.size()) {
            int frameIndex = (Integer)priorities.get((int)var4_6);
            if (frameIndex != -1 && frameIndex < 16) {
                TextColor startColor = this.startColors[frameIndex] == null ? defaultColors.get((Object)ColorType.BORDER_START) : this.startColors[frameIndex];
                TextColor endColor = this.endColors[frameIndex] == null ? defaultColors.get((Object)ColorType.BORDER_END) : this.endColors[frameIndex];
                TextColor startBGColor = this.startBGColors[frameIndex] == null ? defaultColors.get((Object)ColorType.BG_START) : this.startBGColors[frameIndex];
                TextColor endBGColor = this.endBGColors[frameIndex] == null ? defaultColors.get((Object)ColorType.BG_END) : this.endBGColors[frameIndex];
                for (String string : itemSelectors.get(frameIndex).get()) {
                    if (!Selectors.itemMatches((ItemStack)item, (String)string, (HolderLookup.Provider)provider)) continue;
                    FrameDefinition frameDefinition = new FrameDefinition(TooltipDecor.DEFAULT_BORDERS, frameIndex, () -> startColor.getValue(), () -> endColor.getValue(), () -> startBGColor.getValue(), () -> endBGColor.getValue(), FrameSource.CONFIG, (int)var4_6);
                    frameDefinitionCache.put(item, frameDefinition);
                    return frameDefinition;
                }
            } else {
                List sortedDefinitions = customFrameDefinitions.keySet().stream().sorted((a, b) -> Integer.compare(a.priority, b.priority)).toList();
                for (FrameDefinition frameDefinition : sortedDefinitions) {
                    for (String entry : customFrameDefinitions.get(frameDefinition)) {
                        if (!Selectors.itemMatches((ItemStack)item, (String)entry, (HolderLookup.Provider)provider)) continue;
                        frameDefinitionCache.put(item, frameDefinition);
                        return frameDefinition;
                    }
                }
            }
            ++var4_6;
        }
        frameDefinitionCache.put(item, STANDARD_BORDER);
        return STANDARD_BORDER;
    }

    public static void reset() {
        frameDefinitionCache.clear();
        formattedTitleCache.clear();
        LegendaryTooltipsConfig.resolveColors();
    }

    protected void onReload() {
        LegendaryTooltipsConfig.reset();
    }

    private static /* synthetic */ Supplier lambda$new$5(Supplier colorsValue) {
        return colorsValue;
    }

    public static enum ModelRenderType {
        NONE,
        EQUIPMENT,
        ALL;

    }

    public static enum ColorType {
        BORDER_START,
        BORDER_END,
        BG_START,
        BG_END;

    }

    public record FrameDefinition(ResourceLocation resource, int index, Supplier<Integer> startBorder, Supplier<Integer> endBorder, Supplier<Integer> startBackground, Supplier<Integer> endBackground, FrameSource source, int priority) {
    }

    public static enum FrameSource {
        NONE,
        CONFIG,
        API,
        DATA;

    }
}

