/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.config;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class FrameResourceParser
implements ResourceManagerReloadListener {
    public static final FrameResourceParser INSTANCE = new FrameResourceParser();

    private FrameResourceParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onResourceManagerReload(ResourceManager resourceManager) {
        LegendaryTooltipsConfig.reset();
        LegendaryTooltipsConfig.getInstance().clearDataFrames();
        try {
            for (Resource resource : resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)"legendarytooltips", (String)"frame_definitions.json"))) {
                try {
                    InputStream inputStream = resource.open();
                    try {
                        JsonObject rootObject = GsonHelper.parse((Reader)new InputStreamReader(inputStream, Charsets.UTF_8), (boolean)true);
                        if (!rootObject.has("definitions")) continue;
                        JsonArray definitions = GsonHelper.getAsJsonArray((JsonObject)rootObject, (String)"definitions");
                        for (int i = 0; i < definitions.size(); ++i) {
                            Object parsedImage;
                            ResourceLocation imageResourceLocation;
                            JsonObject definitionObject = GsonHelper.convertToJsonObject((JsonElement)definitions.get(i), (String)String.format("definitions[%d]", i));
                            ResourceLocation image = TooltipDecor.DEFAULT_BORDERS;
                            int index = 0;
                            int priority = 0;
                            HashMap<String, TextColor> colors = new HashMap<String, TextColor>(){
                                {
                                    this.put("startColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_START));
                                    this.put("endColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_END));
                                    this.put("bgColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BG_START));
                                    this.put("bgStartColor", null);
                                    this.put("bgEndColor", null);
                                }
                            };
                            ArrayList<String> selectors = new ArrayList<String>();
                            for (JsonElement selectorElement : GsonHelper.getAsJsonArray((JsonObject)definitionObject, (String)"selectors")) {
                                selectors.add(GsonHelper.convertToString((JsonElement)selectorElement, (String)"selector"));
                            }
                            if (definitionObject.has("image") && (imageResourceLocation = ResourceLocation.tryParse((String)(parsedImage = GsonHelper.getAsString((JsonObject)definitionObject, (String)"image")))) != null) {
                                image = imageResourceLocation;
                            }
                            if (definitionObject.has("index")) {
                                index = GsonHelper.getAsInt((JsonObject)definitionObject, (String)"index");
                            }
                            if (definitionObject.has("priority")) {
                                priority = GsonHelper.getAsInt((JsonObject)definitionObject, (String)"priority");
                            }
                            parsedImage = colors.keySet().iterator();
                            while (parsedImage.hasNext()) {
                                String colorKey = (String)parsedImage.next();
                                if (!definitionObject.has(colorKey)) continue;
                                LegendaryTooltipsConfig.ColorType colorType = switch (colorKey) {
                                    case "startColor" -> LegendaryTooltipsConfig.ColorType.BORDER_START;
                                    case "endColor" -> LegendaryTooltipsConfig.ColorType.BORDER_END;
                                    default -> LegendaryTooltipsConfig.ColorType.BG_START;
                                    case "bgEndColor" -> LegendaryTooltipsConfig.ColorType.BG_END;
                                };
                                TextColor parsedColor = null;
                                if (GsonHelper.isStringValue((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.getAsString((JsonObject)definitionObject, (String)colorKey), null, image, index, colorType);
                                } else if (GsonHelper.isNumberValue((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.getAsLong((JsonObject)definitionObject, (String)colorKey), null, image, index, colorType);
                                }
                                if (parsedColor == null) continue;
                                colors.put(colorKey, parsedColor);
                            }
                            LegendaryTooltipsConfig.FrameDefinition definition = new LegendaryTooltipsConfig.FrameDefinition(image, index, () -> ((TextColor)colors.get("startColor")).getValue(), () -> ((TextColor)colors.get("endColor")).getValue(), () -> colors.get("bgStartColor") != null ? ((TextColor)colors.get("bgStartColor")).getValue() : ((TextColor)colors.get("bgColor")).getValue(), () -> colors.get("bgEndColor") != null ? ((TextColor)colors.get("bgEndColor")).getValue() : ((TextColor)colors.get("bgColor")).getValue(), LegendaryTooltipsConfig.FrameSource.DATA, priority);
                            LegendaryTooltipsConfig.getInstance().addFrameDefinition(definition, selectors);
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            LegendaryTooltips.LOGGER.warn("An error occurred while parsing frame definitions data:\n {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

