/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.PaddingComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegendaryTooltips {
    public static final String MODID = "legendarytooltips";
    public static final Logger LOGGER = LogManager.getLogger((String)"legendarytooltips");
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static ItemStack lastTooltipItem = null;

    public static void init() {
        LegendaryTooltipsConfig.register(LegendaryTooltipsConfig.class, (String)MODID);
    }

    public static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(ItemStack item, int defaultStartBorder, int defaultEndBorder, int defaultStartBackground, int defaultEndBackground, HolderLookup.Provider provider) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.getInstance().getFrameDefinition(item, provider);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, () -> defaultEndBorder, () -> defaultStartBackground, () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!LegendaryTooltipsConfig.getInstance().bordersMatchRarity.get().booleanValue()) break;
                DynamicColor rarityColor = DynamicColor.fromRgb((int)ItemColors.getColorForItem((ItemStack)item, (TextColor)TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE)).getValue());
                int hue = rarityColor.hue();
                boolean addHue = false;
                if (hue >= 62 && hue <= 240) {
                    addHue = true;
                }
                int startHue = addHue ? hue - 4 : hue + 4;
                int endHue = addHue ? hue + 18 : hue - 18;
                int startBGHue = addHue ? hue - 3 : hue + 3;
                int endBGHue = addHue ? hue + 13 : hue - 13;
                startHue = (startHue + 360) % 360;
                endHue = (endHue + 360) % 360;
                startBGHue = (startBGHue + 360) % 360;
                endBGHue = (endBGHue + 360) % 360;
                DynamicColor startColor = DynamicColor.fromAHSV((int)255, (int)startHue, (int)rarityColor.saturation(), (int)rarityColor.value());
                DynamicColor endColor = DynamicColor.fromAHSV((int)255, (int)endHue, (int)rarityColor.saturation(), (int)((int)((float)rarityColor.value() * 0.95f)));
                DynamicColor startBGColor = DynamicColor.fromAHSV((int)228, (int)startBGHue, (int)((int)((float)rarityColor.saturation() * 0.9f)), (int)14);
                DynamicColor endBGColor = DynamicColor.fromAHSV((int)253, (int)endBGHue, (int)((int)((float)rarityColor.saturation() * 0.8f)), (int)18);
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> startColor.getIntValue(), () -> endColor.getIntValue(), () -> startBGColor.getIntValue(), () -> endBGColor.getIntValue(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, result.endBorder(), result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), () -> defaultEndBorder, result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.startBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), () -> defaultStartBackground, result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), result.startBackground(), () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(ItemStack itemStack, int screenWidth, int screenHeight, List<Either<FormattedText, TooltipComponent>> tooltipElements, int maxWidth, int index) {
        FormattedText title;
        if (LegendaryTooltipsConfig.getInstance().compactTooltips.get().booleanValue()) {
            for (int i = 0; i < tooltipElements.size(); ++i) {
                TranslatableContents contents;
                MutableComponent component;
                ComponentContents componentContents;
                FormattedText text;
                if (!tooltipElements.get(i).left().isPresent() || !((text = (FormattedText)tooltipElements.get(i).left().get()) instanceof MutableComponent) || !((componentContents = (component = (MutableComponent)text).getContents()) instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().startsWith("item.modifiers.")) continue;
                tooltipElements.remove(i);
                if ((tooltipElements.size() <= i - 1 || i <= 0 || !tooltipElements.get(i - 1).right().isPresent() || tooltipElements.get(i - 1).right().get() != CommonComponents.EMPTY) && (!tooltipElements.get(i - 1).left().isPresent() || !((FormattedText)tooltipElements.get(i - 1).left().get()).getString().isEmpty())) break;
                tooltipElements.remove(i - 1);
                break;
            }
        }
        if (LegendaryTooltipsConfig.showModelForItem(itemStack) && !tooltipElements.isEmpty() && tooltipElements.get(0).left().isPresent() && (title = LegendaryTooltipsConfig.getFormattedTitle((FormattedText)tooltipElements.get(0).left().get())) != null) {
            tooltipElements.set(0, (Either<FormattedText, TooltipComponent>)Either.left((Object)title));
            tooltipElements.add(0, (Either<FormattedText, TooltipComponent>)Either.right((Object)new ItemModelComponent(itemStack)));
            if (tooltipElements.stream().filter(x -> !x.right().isPresent() || !(x.right().get() instanceof Tooltips.TitleBreakComponent)).count() == 2L) {
                tooltipElements.add(2, (Either<FormattedText, TooltipComponent>)Either.right((Object)new PaddingComponent(6)));
            } else {
                tooltipElements.add(2, (Either<FormattedText, TooltipComponent>)Either.right((Object)new PaddingComponent(12)));
            }
        }
        return new RenderTooltipEvents.GatherResult(InteractionResult.PASS, maxWidth, tooltipElements);
    }

    public static void onRenderTick(DeltaTracker tracker) {
        Screen screen;
        if (LegendaryTooltipsConfig.getInstance() == null || !LegendaryTooltipsConfig.getInstance().isLoaded()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        float deltaTime = tracker.getRealtimeDeltaTicks() / 50.0f;
        TooltipDecor.updateTimer(deltaTime);
        ItemModelComponent.updateTimer(deltaTime);
        if (minecraft.screen != null && (screen = minecraft.screen) instanceof AbstractContainerScreen) {
            ItemStack item;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (containerScreen.hoveredSlot != null && containerScreen.hoveredSlot.hasItem() && lastTooltipItem != (item = containerScreen.hoveredSlot.getItem())) {
                TooltipDecor.resetTimer();
                lastTooltipItem = item;
            }
        }
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(ItemStack stack, GuiGraphics graphics, int x, int y, Font font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, List<ClientTooltipComponent> components, boolean comparison, int index) {
        RenderTooltipEvents.ColorExtResult result = new RenderTooltipEvents.ColorExtResult(backgroundStart, backgroundEnd, borderStart, borderEnd);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.level.registryAccess() == null) {
            return result;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd, (HolderLookup.Provider)minecraft.level.registryAccess());
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        TooltipDecor.setCurrentTooltipBackgroundStart(frameDefinition.startBackground().get());
        TooltipDecor.setCurrentTooltipBackgroundEnd(frameDefinition.endBackground().get());
        result = comparison ? new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), 0, 0) : new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue());
        return result;
    }

    public static void onPostTooltipEvent(ItemStack itemStack, GuiGraphics graphics, int x, int y, Font font, int width, int height, List<ClientTooltipComponent> components, boolean comparison, int index) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.level.registryAccess() == null) {
            return;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getInstance().getFrameDefinition(itemStack, (HolderLookup.Provider)minecraft.level.registryAccess());
        if (frameDefinition.index() == -2) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        if (LegendaryTooltipsConfig.getInstance().tooltipShadow.get().booleanValue()) {
            if (comparison) {
                TooltipDecor.drawShadow(poseStack, x, y - 11, width, height + 11);
            } else {
                TooltipDecor.drawShadow(poseStack, x, y, width, height);
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(poseStack, x, y - 11, width, height + 11, itemStack, components, font, frameDefinition, comparison, index);
        } else {
            TooltipDecor.drawBorder(poseStack, x, y, width, height, itemStack, components, font, frameDefinition, comparison, index);
        }
    }
}

