/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.tooltip;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public class TextLine
implements Component {
    protected final TranslatableTextEnum text;
    protected final Style style;
    protected final List<Component> arguments = Lists.newArrayList();
    private MutableComponent component;

    public static TextLine line(TranslatableTextEnum text, Style style) {
        return new TextLine(text, style);
    }

    public static TextLine line(TranslatableTextEnum text) {
        return new TextLine(text);
    }

    public TextLine(TranslatableTextEnum text, Style style) {
        this.text = text;
        this.style = style;
    }

    public TextLine(TranslatableTextEnum text) {
        this(text, null);
    }

    public <T> TextLine arg(T arg, Parser<T> parser) {
        this.arguments.add(parser.parse(arg));
        this.markDirty();
        return this;
    }

    public <A, B> TextLine arg(A a, B b, BiParser<A, B> parser) {
        this.arguments.add(parser.parse(a, b));
        this.markDirty();
        return this;
    }

    protected void markDirty() {
        this.component = null;
    }

    protected MutableComponent createComponent() {
        MutableComponent component = this.text.text(this.arguments.toArray());
        if (this.style != null) {
            component = component.withStyle(this.style);
        }
        return component;
    }

    private MutableComponent component() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    public Style getStyle() {
        return this.component().getStyle();
    }

    public ComponentContents getContents() {
        return this.component().getContents();
    }

    public List<Component> getSiblings() {
        return this.component().getSiblings();
    }

    public FormattedCharSequence getVisualOrderText() {
        return this.component().getVisualOrderText();
    }
}

