/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.tooltip;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.tooltip.BiParser;

public interface Parser<T> {
    public static final Parser<ItemStack> ITEM_STACK = stack -> stack.getHoverName().copy();
    public static final Parser<Item> ITEM = item -> ITEM_STACK.parse(item.getDefaultInstance());
    public static final Parser<Block> BLOCK = Block::getName;
    public static final Parser<BlockState> BLOCK_STATE = blockState -> BLOCK.parse(blockState.getBlock());
    public static final Parser<Fluid> FLUID = fluid -> fluid.getFluidType().getDescription();
    public static final BiParser<HolderLookup.Provider, ResourceKey<Enchantment>> ENCHANTMENT = (registries, enchantment) -> ((Enchantment)registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantment).value()).description().copy();
    public static final Parser<Integer> ENCHANTMENT_LEVEL = level -> Component.translatable((String)"enchantment.level.%d".formatted(level));
    public static final Parser<EntityType> ENTITY_TYPE = entityType -> entityType.getDescription().copy();
    public static final Parser<String> KEYBIND = key -> Component.keybind((String)"key.%s".formatted(key));
    public static final Parser<BlockPos> BLOCK_POS = pos -> Component.literal((String)pos.toShortString());
    public static final BiParser<ResourceKey<Level>, BlockPos> DIMENSION_POS = (dimension, pos) -> Component.literal((String)"%s (%s)".formatted(pos.toShortString(), dimension.location().toString()));
    public static final BiParser<Level, BlockPos> LEVEL_POS = (level, pos) -> DIMENSION_POS.parse((ResourceKey<Level>)level.dimension(), (BlockPos)pos);
    public static final Parser<GlobalPos> GLOBAL_POS = pos -> DIMENSION_POS.parse((ResourceKey<Level>)pos.dimension(), pos.pos());
    public static final Parser<Component> COMPONENT = component -> component;
    public static final Parser<Object> OBJECT = object -> Component.literal((String)String.valueOf(object));

    public Component parse(T var1);

    default public Parser<T> withStyle(Style style) {
        return value -> this.parse(value).copy().setStyle(style);
    }
}

