/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.registry.holder;

import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.fluid.MIBucketItem;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.fluid.MIFluidBlock;
import aztech.modern_industrialization.fluid.MIFluidType;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.registry.MIFluidProperties;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;

public class MIFluidHolder
extends FluidHolder<MIFluid, FakedMIFluidType, MIFluidBlock, MIBucketItem>
implements FluidLike {
    private final MIFluidProperties properties;

    public MIFluidHolder(ResourceLocation location, String englishName, DeferredRegister<Fluid> registerFluids, DeferredRegister<FluidType> registerFluidTypes, DeferredRegister.Blocks registerBlocks, DeferredRegister.Items registerItems, SortOrder bucketSortOrder, MIFluidProperties properties) {
        super(location, englishName, registerFluids, holder -> new MIFluid(() -> (MIFluidBlock)holder.block().get(), () -> holder.bucketItem().get(), () -> (MIFluidType)holder.registerableFluidType().getOrThrow(), properties.color()), registerFluidTypes, holder -> {
            FluidType.Properties fluidTypeProperties = FluidType.Properties.create().descriptionId(((MIFluidBlock)holder.block().get()).getDescriptionId());
            if (properties.isGas()) {
                fluidTypeProperties.density(-1000);
            }
            return new FakedMIFluidType(location.getNamespace(), (DeferredBlock<MIFluidBlock>)((DeferredBlock)holder.block().registerableBlock().get()), fluidTypeProperties);
        }, registerBlocks, (__, ___) -> new MIFluidBlock(properties.color()), registerItems, (holder, p) -> new MIBucketItem((MIFluid)holder.registerableFluid().getOrThrow(), properties.color(), p), bucketSortOrder);
        this.properties = properties;
    }

    public MIFluidProperties properties() {
        return this.properties;
    }

    @Override
    public MIFluidHolder register() {
        super.register();
        return this;
    }

    public static final class FakedMIFluidType
    extends MIFluidType {
        private final String namespace;
        private final DeferredBlock<MIFluidBlock> fluidBlock;

        public FakedMIFluidType(String namespace, DeferredBlock<MIFluidBlock> fluidBlock, FluidType.Properties properties) {
            super(null, properties);
            this.namespace = namespace;
            this.fluidBlock = fluidBlock;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private ResourceLocation textureLocation;

                public ResourceLocation getStillTexture() {
                    if (this.textureLocation == null) {
                        this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"fluid/%s_still".formatted(fluidBlock.getId().getPath()));
                    }
                    return this.textureLocation;
                }

                public ResourceLocation getFlowingTexture() {
                    return IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getFlowingTexture();
                }
            });
        }
    }
}

