/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.registry.holder;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.registry.ModeledRegisteredObjectHolder;
import net.swedz.tesseract.neoforge.registry.registerable.BlockRegisterableWrapper;

public class BlockHolder<BlockType extends Block>
extends ModeledRegisteredObjectHolder<Block, BlockType, BlockStateProvider, BlockHolder<BlockType>> {
    protected final BlockRegisterableWrapper<BlockType> registerableBlock;
    protected Function<BlockLootSubProvider, LootTable.Builder> lootTableBuilder;

    public BlockHolder(ResourceLocation location, String englishName, DeferredRegister.Blocks registerBlocks, Function<BlockBehaviour.Properties, BlockType> blockCreator) {
        super(location, englishName);
        this.registerableBlock = new BlockRegisterableWrapper<BlockType>(registerBlocks, BlockBehaviour.Properties.of(), blockCreator);
    }

    public BlockRegisterableWrapper<BlockType> registerableBlock() {
        return this.registerableBlock;
    }

    public BlockHolder<BlockType> withProperties(Consumer<BlockBehaviour.Properties> action) {
        this.registerableBlock.withProperties(action);
        return (BlockHolder)this.self();
    }

    public BlockHolder<BlockType> withLootTable(Function<BlockHolder<BlockType>, Function<BlockLootSubProvider, LootTable.Builder>> builder) {
        this.lootTableBuilder = builder.apply((BlockHolder)this.self());
        return (BlockHolder)this.self();
    }

    public boolean hasLootTable() {
        return this.lootTableBuilder != null;
    }

    public Function<BlockLootSubProvider, LootTable.Builder> getLootTableBuilder() {
        return this.lootTableBuilder;
    }

    @Override
    public BlockHolder<BlockType> register() {
        this.guaranteeUnlocked();
        this.registerableBlock.register(this.identifier, DeferredRegister.Blocks::registerBlock);
        this.lock();
        return (BlockHolder)this.self();
    }

    @Override
    public BlockType get() {
        return (BlockType)((Block)this.registerableBlock.getOrThrow());
    }
}

