/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.swedz.tesseract.neoforge.helper.AnnotationDataHelper;
import net.swedz.tesseract.neoforge.proxy.LoadedProxy;
import net.swedz.tesseract.neoforge.proxy.Proxy;
import net.swedz.tesseract.neoforge.proxy.ProxyEntrypoint;
import net.swedz.tesseract.neoforge.proxy.ProxyEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadedProxies {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Tesseract API/Proxies");
    private static final Type PROXY_ENTRYPOINT = Type.getType(ProxyEntrypoint.class);
    private final Map<Class<? extends Proxy>, LoadedProxy> proxies = Maps.newHashMap();
    private boolean initialized;

    public <P extends Proxy> P get(Class<P> proxyClass) {
        Objects.requireNonNull(proxyClass);
        if (!this.proxies.containsKey(proxyClass)) {
            throw new IllegalArgumentException("No proxy found for class %s".formatted(proxyClass.getName()));
        }
        return (P)this.proxies.get(proxyClass).proxy();
    }

    @SafeVarargs
    public final <T, I> T merge(Class<I> commonInterface, T startingValue, BiFunction<T, I, T> merge, Class<? extends Proxy> ... proxyClasses) {
        for (Class<? extends Proxy> proxyClass : proxyClasses) {
            if (commonInterface.isAssignableFrom(proxyClass)) continue;
            throw new IllegalArgumentException("Cannot merge proxy class %s as it does not implement %s".formatted(proxyClass, commonInterface));
        }
        T value = startingValue;
        for (Class<? extends Proxy> proxyClass : proxyClasses) {
            Proxy proxy = this.get(proxyClass);
            value = merge.apply(value, proxy);
        }
        return value;
    }

    @SafeVarargs
    public final <T, I> List<T> mergeList(Class<I> commonInterface, Function<I, Collection<T>> merge, Class<? extends Proxy> ... proxyClasses) {
        return this.merge(commonInterface, Lists.newArrayList(), (list, proxy) -> {
            list.addAll((Collection)merge.apply(proxy));
            return list;
        }, proxyClasses);
    }

    @SafeVarargs
    public final <I> boolean mergeAnd(Class<I> commonInterface, Function<I, Boolean> merge, Class<? extends Proxy> ... proxyClasses) {
        return this.merge(commonInterface, true, (value, proxy) -> value != false && (Boolean)merge.apply(proxy) != false, proxyClasses);
    }

    @SafeVarargs
    public final <I> boolean mergeOr(Class<I> commonInterface, Function<I, Boolean> merge, Class<? extends Proxy> ... proxyClasses) {
        return this.merge(commonInterface, false, (value, proxy) -> value != false || (Boolean)merge.apply(proxy) != false, proxyClasses);
    }

    private void add(Class<? extends Proxy> type, Proxy proxy, int priority, EnumSet<ProxyEnvironment> environments) {
        this.proxies.put(type, new LoadedProxy(type, proxy, priority, environments));
    }

    private static Class<? extends Proxy> getProxyKey(Class<? extends Proxy> proxyClass) {
        Class<? extends Proxy> currentClass;
        Class<? extends Proxy> lastProxyClass = currentClass = proxyClass;
        while (Proxy.class.isAssignableFrom(currentClass.getSuperclass())) {
            if (!Proxy.class.isAssignableFrom(currentClass = currentClass.getSuperclass())) continue;
            lastProxyClass = currentClass;
        }
        return lastProxyClass;
    }

    private void registerEntrypoint(ModFileScanData.AnnotationData annotation, int priority, EnumSet<ProxyEnvironment> environments) throws Exception {
        Class<?> entrypointClass = Class.forName(annotation.memberName());
        if (Proxy.class.isAssignableFrom(entrypointClass)) {
            Class<Proxy> proxyClassReference = entrypointClass.asSubclass(Proxy.class);
            Class<? extends Proxy> proxyKey = LoadedProxies.getProxyKey(proxyClassReference);
            LoadedProxy existingProxy = this.proxies.get(proxyKey);
            if (existingProxy == null || existingProxy.priority() < priority || existingProxy.environments().contains((Object)ProxyEnvironment.COMMON)) {
                Proxy proxy = proxyClassReference.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.add(proxyKey, proxy, priority, environments);
            }
        } else {
            LOGGER.error("Invalid proxy entrypoint {}: does not implement Proxy", (Object)annotation.memberName());
        }
    }

    @ApiStatus.Internal
    public void initEntrypoints() {
        if (this.initialized) {
            throw new IllegalStateException("Proxy entrypoints already registered");
        }
        this.initialized = true;
        LOGGER.info("Starting proxy manager entrypoint loader");
        ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(annotation -> PROXY_ENTRYPOINT.equals((Object)annotation.annotationType())).forEach(annotation -> {
            try {
                int priority = annotation.annotationData().getOrDefault("priority", 0);
                EnumSet environments = AnnotationDataHelper.getEnumSetOrDefault((ModFileScanData.AnnotationData)annotation, ProxyEnvironment.class, (String)"environment", (Enum[])new ProxyEnvironment[]{ProxyEnvironment.COMMON});
                if (environments.contains((Object)ProxyEnvironment.COMMON) && environments.size() > 1) {
                    LOGGER.error("Nonsensical proxy entrypoint {}: has multiple environments and one is the common environment", (Object)annotation.memberName());
                    return;
                }
                List modIds = annotation.annotationData().getOrDefault("modid", Lists.newArrayList());
                if (environments.stream().allMatch(e -> e.test(modIds))) {
                    this.registerEntrypoint((ModFileScanData.AnnotationData)annotation, priority, environments);
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Invalid proxy entrypoint {}: Exception constructing proxy entrypoint", (Object)annotation.memberName(), (Object)ex);
            }
        });
        this.proxies.forEach((key, proxy) -> {
            proxy.proxy().init();
            LOGGER.info("Loaded proxy entrypoint {} ({})", (Object)proxy.key().getName(), (Object)proxy.proxy().getClass().getSimpleName());
        });
        LOGGER.info("Done proxy manager entrypoint loader");
    }
}

