/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.slf4j.Logger;

public final class TransferHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<ItemStack> moveAll(IItemHandler source, IItemHandler target, boolean stackInTarget) {
        ArrayList moved = Lists.newArrayList();
        int srcSlots = source.getSlots();
        for (int i = 0; i < srcSlots; ++i) {
            ItemStack leftover;
            ItemStack extracted = source.extractItem(i, Integer.MAX_VALUE, true);
            if (extracted.isEmpty()) continue;
            int extractedCount = extracted.getCount();
            int insertedCount = extractedCount - (leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)true) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)true)).getCount();
            if (insertedCount <= 0 || (extracted = source.extractItem(i, insertedCount, false)).isEmpty()) continue;
            leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)false) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)false);
            moved.add(extracted.copy());
            if (leftover.isEmpty() || (leftover = source.insertItem(i, leftover, false)).isEmpty()) continue;
            LOGGER.warn("Item handler {} rejected {}, discarding.", (Object)target, (Object)leftover);
        }
        return moved;
    }

    public static ItemStack extractMatching(IItemHandler source, Predicate<ItemStack> predicate, int maxAmount) {
        ItemStack stack;
        int slot;
        int sourceSlots = source.getSlots();
        ItemStack ret = ItemStack.EMPTY;
        for (slot = 0; slot < sourceSlots && ret.isEmpty(); ++slot) {
            stack = source.getStackInSlot(slot);
            if (!predicate.test(stack)) continue;
            ret = source.extractItem(slot, maxAmount, false);
        }
        if (ret.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ++slot;
        while (slot < sourceSlots && maxAmount < ret.getCount()) {
            stack = source.getStackInSlot(slot);
            if (ItemStack.matches((ItemStack)stack, (ItemStack)ret)) {
                ItemStack extracted = source.extractItem(slot, maxAmount - ret.getCount(), true);
                ret.grow(extracted.getCount());
            }
            ++slot;
        }
        return ret;
    }

    public static int move(IEnergyStorage source, IEnergyStorage target, int maxAmount) {
        int leftover;
        int simulatedExtract = source.extractEnergy(maxAmount, true);
        int simulatedInsert = target.receiveEnergy(simulatedExtract, true);
        int extractedAmount = source.extractEnergy(simulatedInsert, false);
        int insertedAmount = target.receiveEnergy(extractedAmount, false);
        if (insertedAmount < extractedAmount && (leftover = source.receiveEnergy(extractedAmount - insertedAmount, false)) > 0) {
            LOGGER.error("Energy storage {} did not accept {} leftover energy from {}! Voiding it.", new Object[]{source, leftover, target});
        }
        return insertedAmount;
    }
}

