/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.hook;

import aztech.modern_industrialization.machines.models.MachineCasing;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.datagen.mi.client.MachineCasingModelsMIHookDatagenProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MIHookTracker {
    private static String TRACKING_MOD_ID;
    private static final Map<ResourceLocation, String> REI_CATEGORY_NAMES;
    private static final Map<ResourceLocation, MachineModelProperties> MACHINE_MODELS;
    private static final Map<String, List<Consumer<MachineCasingModelsMIHookDatagenProvider>>> MACHINE_CASING_MODELS;

    public static void startTracking(String modId) {
        if (MIHookTracker.isTracking()) {
            throw new IllegalStateException("Tried to start tracking while there is already an active tracker");
        }
        TRACKING_MOD_ID = modId;
    }

    public static void stopTracking() {
        TRACKING_MOD_ID = null;
    }

    public static boolean isTracking() {
        return TRACKING_MOD_ID != null;
    }

    public static void assertTracking() {
        if (!MIHookTracker.isTracking()) {
            throw new IllegalStateException("Tracker is not open right now");
        }
    }

    public static void assertNotTracking() {
        if (MIHookTracker.isTracking()) {
            throw new IllegalStateException("Tracker is open right now");
        }
    }

    public static String getTrackingModId() {
        return TRACKING_MOD_ID;
    }

    public static ResourceLocation id(String id) {
        MIHookTracker.assertTracking();
        return ResourceLocation.fromNamespaceAndPath((String)TRACKING_MOD_ID, (String)id);
    }

    public static List<Map.Entry<ResourceLocation, String>> getReiCategoryNames(String modId) {
        return REI_CATEGORY_NAMES.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals(modId)).toList();
    }

    public static void addReiCategoryName(ResourceLocation categoryId, String englishName) {
        REI_CATEGORY_NAMES.put(categoryId, englishName);
    }

    public static MachineModelProperties getMachineModel(ResourceLocation id) {
        return MACHINE_MODELS.get(id);
    }

    public static void addMachineModel(ResourceLocation id, MachineCasing defaultCasing, String overlay, boolean front, boolean top, boolean side, boolean active) {
        MACHINE_MODELS.put(id, new MachineModelProperties(id.getNamespace(), defaultCasing, overlay, front, top, side, active));
    }

    public static List<Consumer<MachineCasingModelsMIHookDatagenProvider>> getMachineCasingModels(String modId) {
        return MACHINE_CASING_MODELS.computeIfAbsent(modId, k -> Lists.newArrayList());
    }

    public static void addMachineCasingModel(String name, Consumer<MachineCasingModelsMIHookDatagenProvider> action) {
        MIHookTracker.assertTracking();
        MACHINE_CASING_MODELS.computeIfAbsent(TRACKING_MOD_ID, k -> Lists.newArrayList()).add(action);
    }

    static {
        REI_CATEGORY_NAMES = Maps.newHashMap();
        MACHINE_MODELS = Maps.newHashMap();
        MACHINE_CASING_MODELS = Maps.newHashMap();
    }

    public record MachineModelProperties(String modId, MachineCasing defaultCasing, String overlay, boolean front, boolean top, boolean side, boolean active) {
        public void addToMachineJson(JsonObject json) {
            json.addProperty("casing", this.defaultCasing.name);
            JsonObject defaultOverlays = new JsonObject();
            if (this.top) {
                defaultOverlays.addProperty("top", "%s:block/machines/%s/overlay_top".formatted(this.modId, this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("top_active", "%s:block/machines/%s/overlay_top_active".formatted(this.modId, this.overlay));
                }
            }
            if (this.front) {
                defaultOverlays.addProperty("front", "%s:block/machines/%s/overlay_front".formatted(this.modId, this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("front_active", "%s:block/machines/%s/overlay_front_active".formatted(this.modId, this.overlay));
                }
            }
            if (this.side) {
                defaultOverlays.addProperty("side", "%s:block/machines/%s/overlay_side".formatted(this.modId, this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("side_active", "%s:block/machines/%s/overlay_side_active".formatted(this.modId, this.overlay));
                }
            }
            defaultOverlays.addProperty("output", "%s:block/overlays/output".formatted("modern_industrialization"));
            defaultOverlays.addProperty("item_auto", "%s:block/overlays/item_auto".formatted("modern_industrialization"));
            defaultOverlays.addProperty("fluid_auto", "%s:block/overlays/fluid_auto".formatted("modern_industrialization"));
            json.add("default_overlays", (JsonElement)defaultOverlays);
        }
    }
}

