/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component.craft;

import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccess;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookEfficiency;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHooks;
import net.swedz.tesseract.neoforge.compat.mi.hook.context.machine.EfficiencyMIHookContext;

public abstract class AbstractModularCrafterComponent<R>
implements IComponent.ServerOnly,
ModularCrafterAccess<R> {
    protected final MachineProcessCondition.Context conditionContext;
    protected final CrafterComponent.Inventory inventory;
    protected final ModularCrafterAccessBehavior behavior;
    protected R activeRecipe;
    protected ResourceLocation delayedActiveRecipe;
    protected long usedEnergy;
    protected long recipeEnergy;
    protected long recipeMaxEu;
    protected int efficiencyTicks;
    protected int maxEfficiencyTicks;
    protected long previousBaseEu = -1L;
    protected long previousMaxEu = -1L;
    protected int lastInvHash = 0;
    protected int lastForcedTick = 0;

    public AbstractModularCrafterComponent(MachineBlockEntity blockEntity, CrafterComponent.Inventory inventory, ModularCrafterAccessBehavior behavior) {
        this.inventory = inventory;
        this.behavior = behavior;
        this.conditionContext = () -> blockEntity;
    }

    protected long transformEuCost(long eu) {
        return eu;
    }

    protected abstract boolean canContinueRecipe();

    protected abstract Iterable<R> getRecipes();

    protected abstract ResourceLocation getRecipeId(R var1);

    protected abstract R getRecipeById(ResourceLocation var1);

    protected abstract void onTick();

    protected boolean takeInputs(R recipe, boolean simulate) {
        return this.takeItemInputs(recipe, simulate) && this.takeFluidInputs(recipe, simulate);
    }

    protected abstract boolean takeItemInputs(R var1, boolean var2);

    protected abstract boolean takeFluidInputs(R var1, boolean var2);

    protected boolean putOutputs(R recipe, boolean simulate, boolean toggleLock) {
        return this.putItemOutputs(recipe, simulate, toggleLock) && this.putFluidOutputs(recipe, simulate, toggleLock);
    }

    protected abstract boolean putItemOutputs(R var1, boolean var2, boolean var3);

    protected abstract boolean putFluidOutputs(R var1, boolean var2, boolean var3);

    public abstract void lockRecipe(ResourceLocation var1, Inventory var2);

    public InventoryAccess getInventory() {
        return this.inventory;
    }

    @Override
    public ModularCrafterAccessBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.activeRecipe != null;
    }

    @Override
    public R getActiveRecipe() {
        return this.activeRecipe;
    }

    public float getProgress() {
        return (float)this.usedEnergy / (float)this.recipeEnergy;
    }

    public int getEfficiencyTicks() {
        return this.efficiencyTicks;
    }

    public int getMaxEfficiencyTicks() {
        return this.maxEfficiencyTicks;
    }

    public long getCurrentRecipeEu() {
        return this.recipeMaxEu;
    }

    @Override
    public void decreaseEfficiencyTicks() {
        EfficiencyMIHookContext context = new EfficiencyMIHookContext(this.conditionContext.getBlockEntity(), this.hasActiveRecipe(), this.maxEfficiencyTicks, this.efficiencyTicks, this.recipeMaxEu);
        MIHooks.triggerHookEfficiencyListeners(context, MIHookEfficiency::onDecreaseEfficiencyTicks);
        if (context.isCancelled()) {
            return;
        }
        this.efficiencyTicks = Math.max(this.efficiencyTicks - 1, 0);
        this.clearActiveRecipeIfPossible();
    }

    @Override
    public void increaseEfficiencyTicks(int increment) {
        EfficiencyMIHookContext context = new EfficiencyMIHookContext(this.conditionContext.getBlockEntity(), this.hasActiveRecipe(), this.maxEfficiencyTicks, this.efficiencyTicks, this.recipeMaxEu);
        MIHooks.triggerHookEfficiencyListeners(context, MIHookEfficiency::onIncreaseEfficiencyTicks);
        if (context.isCancelled()) {
            return;
        }
        this.efficiencyTicks = Math.min(this.efficiencyTicks + increment, this.maxEfficiencyTicks);
    }

    public boolean tryContinueRecipe() {
        this.loadDelayedActiveRecipe();
        if (this.hasActiveRecipe() && this.canContinueRecipe()) {
            if (this.putOutputs(this.activeRecipe, true, false)) {
                this.putOutputs(this.activeRecipe, true, true);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void loadDelayedActiveRecipe() {
        if (this.delayedActiveRecipe != null) {
            this.activeRecipe = this.getRecipeById(this.delayedActiveRecipe);
            this.delayedActiveRecipe = null;
            if (this.activeRecipe == null) {
                this.efficiencyTicks = 0;
                this.usedEnergy = 0L;
            }
        }
    }

    protected boolean updateActiveRecipe() {
        for (R recipe : this.getRecipes()) {
            if (this.behavior.isRecipeBanned(this.getRecipeEuCost(recipe)) || !this.tryStartRecipe(recipe)) continue;
            if (this.activeRecipe != recipe || this.efficiencyTicks == 0) {
                this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks(recipe);
            }
            this.activeRecipe = recipe;
            this.usedEnergy = 0L;
            this.recipeEnergy = this.transformEuCost(this.getRecipeTotalEuCost(recipe));
            this.recipeMaxEu = this.getRecipeMaxEu(this.getRecipeEuCost(recipe), this.recipeEnergy, this.efficiencyTicks);
            return true;
        }
        return false;
    }

    protected boolean tryStartRecipe(R recipe) {
        if (this.takeInputs(recipe, true) && this.putOutputs(recipe, true, false) && this.doConditionsMatchForRecipe(recipe)) {
            this.takeInputs(recipe, false);
            this.putOutputs(recipe, true, true);
            return true;
        }
        return false;
    }

    public boolean tickRecipe() {
        if (this.behavior.getCrafterWorld().isClientSide()) {
            throw new IllegalStateException("May not call client side.");
        }
        EfficiencyMIHookContext context = new EfficiencyMIHookContext(this.conditionContext.getBlockEntity(), this.hasActiveRecipe(), this.maxEfficiencyTicks, this.efficiencyTicks, this.recipeMaxEu);
        MIHooks.triggerHookEfficiencyListeners(context, MIHookEfficiency::onTickStart);
        this.efficiencyTicks = context.getEfficiencyTicks();
        this.onTick();
        boolean active = false;
        boolean enabled = this.behavior.isEnabled();
        this.loadDelayedActiveRecipe();
        boolean started = false;
        if (this.usedEnergy == 0L && enabled && this.behavior.canConsumeEu(1L)) {
            started = this.updateActiveRecipe();
        }
        long eu = 0L;
        boolean finished = false;
        if (this.activeRecipe != null && enabled) {
            if (this.usedEnergy > 0L || started) {
                this.recipeMaxEu = this.getRecipeMaxEu(this.getRecipeEuCost(this.activeRecipe), this.recipeEnergy, this.efficiencyTicks);
                eu = this.doConditionsMatchForRecipe(this.activeRecipe) ? this.behavior.consumeEu(Math.min(this.recipeMaxEu, this.recipeEnergy - this.usedEnergy), Simulation.ACT) : 0L;
                active = eu > 0L;
                this.usedEnergy += eu;
                if (this.usedEnergy == this.recipeEnergy) {
                    this.putOutputs(this.activeRecipe, false, false);
                    this.clearLocks();
                    this.usedEnergy = 0L;
                    finished = true;
                }
            } else if (this.behavior.isOverdriving()) {
                eu = this.doConditionsMatchForRecipe(this.activeRecipe) ? this.behavior.consumeEu(this.recipeMaxEu, Simulation.ACT) : 0L;
                boolean bl = active = eu > 0L;
            }
        }
        if (this.activeRecipe != null && (this.previousBaseEu != this.behavior.getBaseRecipeEu() || this.previousMaxEu != this.behavior.getMaxRecipeEu())) {
            this.previousBaseEu = this.behavior.getBaseRecipeEu();
            this.previousMaxEu = this.behavior.getMaxRecipeEu();
            this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks(this.activeRecipe);
            this.efficiencyTicks = Math.min(this.efficiencyTicks, this.maxEfficiencyTicks);
        }
        if (finished) {
            if (this.efficiencyTicks < this.maxEfficiencyTicks) {
                ++this.efficiencyTicks;
            }
        } else if (eu < this.recipeMaxEu && this.efficiencyTicks > 0) {
            --this.efficiencyTicks;
        }
        long euUsed = eu;
        EfficiencyMIHookContext context2 = new EfficiencyMIHookContext(this.conditionContext.getBlockEntity(), this.hasActiveRecipe(), this.maxEfficiencyTicks, this.efficiencyTicks, this.recipeMaxEu);
        MIHooks.triggerHookEfficiencyListeners(context2, (h, c) -> h.onTickEnd((EfficiencyMIHookContext)c, euUsed));
        this.efficiencyTicks = context2.getEfficiencyTicks();
        this.clearActiveRecipeIfPossible();
        return active;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("usedEnergy", this.usedEnergy);
        tag.putLong("recipeEnergy", this.recipeEnergy);
        tag.putLong("recipeMaxEu", this.recipeMaxEu);
        if (this.hasActiveRecipe()) {
            tag.putString("activeRecipe", this.getRecipeId(this.activeRecipe).toString());
        } else if (this.delayedActiveRecipe != null) {
            tag.putString("activeRecipe", this.delayedActiveRecipe.toString());
        }
        tag.putInt("efficiencyTicks", this.efficiencyTicks);
        tag.putInt("maxEfficiencyTicks", this.maxEfficiencyTicks);
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.usedEnergy = tag.getInt("usedEnergy");
        this.recipeEnergy = tag.getInt("recipeEnergy");
        this.recipeMaxEu = tag.getInt("recipeMaxEu");
        ResourceLocation resourceLocation = this.delayedActiveRecipe = tag.contains("activeRecipe") ? ResourceLocation.parse((String)tag.getString("activeRecipe")) : null;
        if (this.delayedActiveRecipe == null && this.usedEnergy > 0L) {
            this.usedEnergy = 0L;
            Tesseract.LOGGER.error("Had to set the usedEnergy of MultipliedCrafterComponent to 0, but that should never happen!");
        }
        this.efficiencyTicks = tag.getInt("efficiencyTicks");
        this.maxEfficiencyTicks = tag.getInt("maxEfficiencyTicks");
        EfficiencyMIHookContext context = new EfficiencyMIHookContext(this.conditionContext.getBlockEntity(), this.hasActiveRecipe(), this.maxEfficiencyTicks, this.efficiencyTicks, this.recipeMaxEu);
        MIHooks.triggerHookEfficiencyListeners(context, MIHookEfficiency::onReadNbt);
        this.efficiencyTicks = context.getEfficiencyTicks();
        this.recipeMaxEu = context.getMaxRecipeEu();
    }

    protected void clearActiveRecipes() {
        this.activeRecipe = null;
    }

    protected void clearActiveRecipeIfPossible() {
        if (this.efficiencyTicks == 0 && this.usedEnergy == 0L) {
            this.clearActiveRecipes();
        }
    }

    protected long getRecipeMaxEu(long recipeEu, long totalEu, int efficiencyTicks) {
        long baseEu = Math.max(this.transformEuCost(this.behavior.getBaseRecipeEu()), this.transformEuCost(recipeEu));
        return Math.min(totalEu, Math.min((long)((int)Math.floor((double)baseEu * CrafterComponent.getEfficiencyOverclock((int)efficiencyTicks))), this.transformEuCost(this.behavior.getMaxRecipeEu())));
    }

    protected int getRecipeMaxEfficiencyTicks(R recipe) {
        long eu = this.getRecipeEuCost(recipe);
        long totalEu = this.transformEuCost(this.getRecipeTotalEuCost(recipe));
        int ticks = 0;
        while (this.getRecipeMaxEu(eu, totalEu, ticks) != Math.min(this.transformEuCost(this.behavior.getMaxRecipeEu()), totalEu)) {
            ++ticks;
        }
        return ticks;
    }

    protected void clearLocks() {
        for (ConfigurableItemStack stack : this.inventory.getItemOutputs()) {
            if (!stack.isMachineLocked()) continue;
            stack.disableMachineLock();
        }
        for (ConfigurableItemStack stack : this.inventory.getFluidOutputs()) {
            if (!stack.isMachineLocked()) continue;
            stack.disableMachineLock();
        }
    }

    protected static void lockAll(List<? extends AbstractConfigurableStack<?, ?>> stacks) {
        for (AbstractConfigurableStack<?, ?> stack : stacks) {
            if (!stack.isEmpty() || stack.getLockedInstance() != null) continue;
            stack.togglePlayerLock();
        }
    }
}

