/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.util;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.data.ITags;
import owmii.powah.lib.block.AbstractEnergyBlock;

public final class Wrench {
    private Wrench() {
    }

    public static boolean removeWithWrench(Player player, Level world, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isSpectator() || !player.isShiftKeyDown() || !world.mayInteract(player, hitResult.getBlockPos()) || !stack.is(ITags.Items.WRENCHES)) {
            return false;
        }
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof AbstractEnergyBlock || state.getBlock() instanceof EnergizingOrbBlock) {
            BlockEntity entity = world.getBlockEntity(pos);
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (!player.isCreative()) {
                Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
            }
            SoundType group = state.getSoundType();
            world.playSound(player, pos, group.getBreakSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
            return true;
        }
        return false;
    }
}

