/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.item.IEnergyItemProvider;
import owmii.powah.lib.item.VarItem;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.util.Util;

public abstract class EnergyItem<V extends Enum<V>, C extends IEnergyConfig<V>, I extends EnergyItem<V, C, I>>
extends VarItem<V, I>
implements InfoBox.IInfoBoxHolder,
IEnergyItemProvider,
IEnergyContainingItem {
    public EnergyItem(Item.Properties properties, V variant) {
        super(properties, variant);
    }

    public EnergyItem(Item.Properties properties) {
        super(properties);
    }

    public abstract IEnergyConfig<V> getConfig();

    @Override
    public IEnergyContainingItem.Info getEnergyInfo() {
        IEnergyConfig config = this.getConfig();
        return new IEnergyContainingItem.Info(config.getCapacity(this.getVariant()), config.getTransfer(this.getVariant()), config.getTransfer(this.getVariant()));
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Energy.ifPresent(stack, energy -> {
            if (energy.getCapacity() > 0L) {
                tooltip.add((Component)Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
                tooltip.add((Component)Component.translatable((String)"info.lollipop.max.io").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).withStyle(ChatFormatting.DARK_GRAY)));
            }
        });
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, energy -> {
            box.set(Component.translatable((String)"info.lollipop.capacity"), Component.translatable((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(energy.getCapacity())}));
            box.set(Component.translatable((String)"info.lollipop.max.io"), Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(energy.getMaxExtract())}));
        });
        return box;
    }
}

