/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import owmii.powah.components.PowahComponents;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.IBlockEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Redstone;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;

public class AbstractTileEntity<V extends IVariant, B extends AbstractBlock<V, B>>
extends BlockEntity
implements IBlockEntity,
IRedstoneInteract {
    protected final Inventory inv = Inventory.createBlank();
    protected final Tank tank = new Tank(0);
    protected V variant;
    protected boolean isContainerOpen;
    private Redstone redstone = Redstone.IGNORE;

    public AbstractTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, IVariant.getEmpty());
        this.tank.setValidator(stack -> true);
    }

    public AbstractTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, V variant) {
        super(type, pos, state);
        this.variant = variant;
        if (this instanceof IInventoryHolder) {
            this.inv.setTile((IInventoryHolder)((Object)this));
        }
    }

    public B getBlock() {
        return (B)((AbstractBlock)this.getBlockState().getBlock());
    }

    public V getVariant() {
        return this.variant;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readSync(tag, registries);
        if (!tag.contains("#c")) {
            this.loadServerOnly(tag);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.writeSync(tag, registries);
        this.saveServerOnly(tag);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = this.saveWithoutMetadata(registries);
        tag.putBoolean("#c", true);
        return tag;
    }

    @Nullable
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadServerOnly(CompoundTag compound) {
    }

    protected CompoundTag saveServerOnly(CompoundTag compound) {
        return compound;
    }

    protected void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (!this.variant.isEmpty() && nbt.contains("variant", 3)) {
            this.variant = (IVariant)this.variant.read(nbt, "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            this.inv.deserializeNBT(nbt, registries);
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && !(tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.readFromNBT(nbt, registries);
        }
        this.redstone = Redstone.values()[nbt.getInt("redstone_mode")];
        this.readStorable(nbt, registries);
    }

    protected CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (!this.variant.isEmpty()) {
            this.variant.write(nbt, (Enum)((Enum)this.variant), "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            nbt.merge(this.inv.serializeNBT(registries));
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && !(tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.writeToNBT(nbt, registries);
        }
        nbt.putInt("redstone_mode", this.redstone.ordinal());
        return this.writeStorable(nbt, registries);
    }

    public void readStorable(CompoundTag nbt, HolderLookup.Provider registries) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            this.inv.deserializeNBT(nbt, registries);
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && (tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.readFromNBT(nbt, registries);
        }
    }

    public CompoundTag writeStorable(CompoundTag nbt, HolderLookup.Provider registries) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            nbt.merge(this.inv.serializeNBT(registries));
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && (tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.writeToNBT(nbt, registries);
        }
        return nbt;
    }

    @Override
    public void onPlaced(Level world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CustomData storedState = (CustomData)stack.get(PowahComponents.STORED_BLOCK_ENTITY_STATE);
        if (storedState != null) {
            this.readStorable(storedState.copyTag(), (HolderLookup.Provider)this.level.registryAccess());
        }
    }

    @Override
    public void onRemoved(Level world, BlockState state, BlockState newState, boolean isMoving) {
        if (!(state.getBlock() == newState.getBlock() || !(this instanceof IInventoryHolder) || this.keepInventory() && this.keepStorable())) {
            this.getInventory().drop(world, this.worldPosition);
        }
    }

    public ItemStack storeToStack(ItemStack stack) {
        CompoundTag nbt = this.writeStorable(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess());
        if (!nbt.isEmpty() && this.keepStorable()) {
            stack.set(PowahComponents.STORED_BLOCK_ENTITY_STATE, (Object)CustomData.of((CompoundTag)nbt));
        }
        return stack;
    }

    public boolean keepStorable() {
        return true;
    }

    protected boolean keepInventory() {
        return false;
    }

    public Tank getTank() {
        return this.tank;
    }

    @Override
    public Redstone getRedstoneMode() {
        return this.redstone;
    }

    @Override
    public void setRedstoneMode(Redstone mode) {
        this.redstone = mode;
    }

    public boolean checkRedstone() {
        boolean power = this.level != null && this.level.getBestNeighborSignal(this.worldPosition) > 0;
        return Redstone.IGNORE.equals((Object)this.getRedstoneMode()) || power && Redstone.ON.equals((Object)this.getRedstoneMode()) || !power && Redstone.OFF.equals((Object)this.getRedstoneMode());
    }

    public void sync() {
        if (this.level instanceof ServerLevel) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            this.setChanged();
        }
    }

    public boolean isRemote() {
        return this.level != null && this.level.isClientSide;
    }

    public void setContainerOpen(boolean value) {
        boolean b = this.isContainerOpen;
        this.isContainerOpen = value;
        if (b != value) {
            this.sync();
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

