/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.item.ReactorItem;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.util.Util;

public class ReactorBlock
extends AbstractGeneratorBlock<ReactorBlock> {
    public static final BooleanProperty CORE = BooleanProperty.create((String)"core");

    public ReactorBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties.isValidSpawn((state, blockGetter, blockPos, entityType) -> false), variant);
        this.setStateProps(state -> (BlockState)state.setValue((Property)CORE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return new ReactorItem(this, properties, group);
    }

    @Override
    public GeneratorConfig getConfig() {
        return Powah.config().generators.reactors;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)CORE)).booleanValue()) {
            return new ReactorTile(pos, state, (Tier)this.variant);
        }
        return new ReactorPartTile(pos, state, (Tier)this.variant);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getPlayer() != null ? (BlockState)this.defaultBlockState().setValue((Property)CORE, (Comparable)Boolean.valueOf(true)) : super.getStateForPlacement(context);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        Tank tank;
        ReactorTile reactor;
        BlockEntity tileentity = pLevel.getBlockEntity(pPos);
        if (tileentity instanceof ReactorPartTile) {
            ReactorPartTile reactor2 = (ReactorPartTile)tileentity;
            if (reactor2.isBuilt() && reactor2.core().isPresent()) {
                return ((ReactorBlock)reactor2.getBlock()).useItemOn(pStack, pState, pLevel, reactor2.getCorePos(), pPlayer, pHand, pHitResult);
            }
        } else if (tileentity instanceof ReactorTile && (reactor = (ReactorTile)tileentity).isBuilt() && FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (IFluidHandler)(tank = reactor.getTank()))) {
            reactor.sync();
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        ReactorPartTile reactor;
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof ReactorPartTile && (reactor = (ReactorPartTile)tileentity).isBuilt() && reactor.core().isPresent()) {
            return ((ReactorBlock)reactor.getBlock()).useWithoutItem(state, world, reactor.getCorePos(), player, result);
        }
        return super.useWithoutItem(state, world, pos, player, result);
    }

    @Override
    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof ReactorTile) {
            return new ReactorContainer(id, inventory, (ReactorTile)te);
        }
        return null;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.demolish(world);
        } else if (tileentity instanceof ReactorPartTile) {
            ReactorPartTile tile = (ReactorPartTile)tileentity;
            tile.demolish(world);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CORE});
    }

    @Override
    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"info.powah.generation.factor").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(this.getConfig().getGeneration((Tier)this.variant))}).withStyle(ChatFormatting.DARK_GRAY)));
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, energy -> {
            box.set(Component.translatable((String)"info.lollipop.capacity"), Component.translatable((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(energy.getCapacity())}));
            box.set(Component.translatable((String)"info.powah.generation.factor"), Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(this.getConfig().getGeneration((Tier)this.variant))}));
            box.set(Component.translatable((String)"info.lollipop.max.extract"), Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(energy.getMaxExtract())}));
        });
        return box;
    }
}

