/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.data.Player;
import net.creeperhost.levelio.lib.BlockIdConverter;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.creeperhost.levelio.loader.LevelLoader;
import net.creeperhost.levelio.loader.LevelType;
import net.creeperhost.levelio.loader.PlayerLoader;
import net.creeperhost.levelio.loader.SaveInfo;
import org.jetbrains.annotations.Nullable;

public class LevelIO {
    private final ICompoundTag levelData;
    private final LevelLoader levelLoader;
    private final PlayerLoader playerLoader;
    public final Path worldFolder;
    public final SaveInfo saveInfo;
    public final NBTHandler nbtHandler;

    private LevelIO(ICompoundTag levelData, Path worldFolder, boolean readOnly, NBTHandler nbtHandler) {
        this.levelData = levelData;
        this.worldFolder = worldFolder;
        this.saveInfo = new SaveInfo(levelData);
        this.nbtHandler = nbtHandler;
        this.playerLoader = new PlayerLoader(levelData, worldFolder, nbtHandler);
        this.levelLoader = new LevelLoader(this, worldFolder, readOnly);
        BlockIdConverter.init(nbtHandler);
    }

    public static LevelIO create(Path worldFolder, boolean readOnly, NBTHandler nbtHandler) throws IOException {
        ICompoundTag levelData;
        readOnly = true;
        Path levelDat = worldFolder.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new FileNotFoundException("Did not fine a level.dat file in the specified save folder");
        }
        ICompoundTag tag = nbtHandler.read(levelDat);
        ICompoundTag iCompoundTag = levelData = tag != null ? tag.getCompound("Data") : null;
        if (levelData == null) {
            throw new IOException("Detected invalid level.dat file");
        }
        return new LevelIO(levelData, worldFolder, readOnly, nbtHandler);
    }

    @Nullable
    public Level getLevel(LevelType type, @Nullable String identifier) {
        return this.levelLoader.getLevel(type, identifier);
    }

    @Nullable
    public Level getLevel(String identifier) {
        return this.levelLoader.getLevel(LevelType.getType(identifier), identifier);
    }

    public List<Level> getLevels() {
        return this.levelLoader.getLevels();
    }

    public Map<UUID, Player> getPlayers() {
        return this.playerLoader.getPlayers();
    }

    public void close() {
        this.levelLoader.close();
    }
}

