/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class AnimatedGifEncoder {
    protected int width;
    protected int height;
    protected Color transparent = null;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 0;
    protected boolean started = false;
    protected OutputStream out;
    protected BufferedImage image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 10;

    public void setDelay(int ms) {
        this.delay = Math.round((float)ms / 10.0f);
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void setTransparent(Color c) {
        this.transparent = c;
    }

    public void addFrame(BufferedImage im) throws IOException {
        Objects.requireNonNull(im);
        if (!this.started) {
            throw new IllegalStateException("Not currently writing.");
        }
        if (!this.sizeSet) {
            this.setSize(im.getWidth(), im.getHeight());
        }
        this.image = im;
        this.getImagePixels();
        this.analyzePixels();
        if (this.firstFrame) {
            this.writeLSD();
            this.writePalette();
            if (this.repeat >= 0) {
                this.writeNetscapeExt();
            }
        }
        this.writeGraphicCtrlExt();
        this.writeImageDesc();
        if (!this.firstFrame) {
            this.writePalette();
        }
        this.writePixels();
        this.firstFrame = false;
    }

    public void finish() throws IOException {
        if (!this.started) {
            throw new IllegalStateException("Not currently writing.");
        }
        this.started = false;
        this.out.write(59);
        this.out.flush();
        if (this.closeStream) {
            this.out.close();
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
    }

    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            this.delay = Math.round(100.0f / fps);
        }
    }

    public void setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.sample = quality;
    }

    public void setSize(int w, int h) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void start(OutputStream os) throws IOException {
        Objects.requireNonNull(os);
        this.closeStream = false;
        this.out = os;
        this.writeString("GIF89a");
        this.started = true;
    }

    public void start(String file) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(file));
        this.start(this.out);
        this.closeStream = true;
    }

    protected void analyzePixels() {
        int len = this.pixels.length;
        int nPix = len / 3;
        this.indexedPixels = new byte[nPix];
        NeuQuant nq = new NeuQuant(this.pixels, len, this.sample);
        this.colorTab = nq.process();
        for (int i = 0; i < this.colorTab.length; i += 3) {
            byte temp = this.colorTab[i];
            this.colorTab[i] = this.colorTab[i + 2];
            this.colorTab[i + 2] = temp;
            this.usedEntry[i / 3] = false;
        }
        int k = 0;
        for (int i = 0; i < nPix; ++i) {
            int index = nq.map(this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF);
            this.usedEntry[index] = true;
            this.indexedPixels[i] = (byte)index;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
        }
    }

    protected int findClosest(Color c) {
        if (this.colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int minpos = 0;
        int dmin = 0x1000000;
        int len = this.colorTab.length;
        for (int i = 0; i < len; ++i) {
            int dr = r - (this.colorTab[i++] & 0xFF);
            int dg = g - (this.colorTab[i++] & 0xFF);
            int db = b - (this.colorTab[i] & 0xFF);
            int d = dr * dr + dg * dg + db * db;
            int index = i / 3;
            if (!this.usedEntry[index] || d >= dmin) continue;
            dmin = d;
            minpos = index;
        }
        return minpos;
    }

    protected void getImagePixels() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int type = this.image.getType();
        if (w != this.width || h != this.height || type != 5) {
            BufferedImage temp = new BufferedImage(this.width, this.height, 5);
            Graphics2D g = temp.createGraphics();
            g.drawImage((Image)this.image, 0, 0, null);
            this.image = temp;
        }
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }

    private static class LZWEncoder {
        private static final int EOF = -1;
        private int imgW;
        private int imgH;
        private byte[] pixAry;
        private int initCodeSize;
        private int remaining;
        private int curPixel;
        static final int BITS = 12;
        static final int HSIZE = 5003;
        int n_bits;
        int maxbits = 12;
        int maxcode;
        int maxmaxcode = 4096;
        int[] htab = new int[5003];
        int[] codetab = new int[5003];
        int hsize = 5003;
        int free_ent = 0;
        boolean clear_flg = false;
        int g_init_bits;
        int ClearCode;
        int EOFCode;
        int cur_accum = 0;
        int cur_bits = 0;
        int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        int a_count;
        byte[] accum = new byte[256];

        LZWEncoder(int width, int height, byte[] pixels, int color_depth) {
            this.imgW = width;
            this.imgH = height;
            this.pixAry = pixels;
            this.initCodeSize = Math.max(2, color_depth);
        }

        void char_out(byte c, OutputStream outs) throws IOException {
            this.accum[this.a_count++] = c;
            if (this.a_count >= 254) {
                this.flush_char(outs);
            }
        }

        void cl_block(OutputStream outs) throws IOException {
            this.cl_hash(this.hsize);
            this.free_ent = this.ClearCode + 2;
            this.clear_flg = true;
            this.output(this.ClearCode, outs);
        }

        void cl_hash(int hsize) {
            for (int i = 0; i < hsize; ++i) {
                this.htab[i] = -1;
            }
        }

        void compress(int init_bits, OutputStream outs) throws IOException {
            int c;
            int fcode;
            this.g_init_bits = init_bits;
            this.clear_flg = false;
            this.n_bits = this.g_init_bits;
            this.maxcode = this.MAXCODE(this.n_bits);
            this.ClearCode = 1 << init_bits - 1;
            this.EOFCode = this.ClearCode + 1;
            this.free_ent = this.ClearCode + 2;
            this.a_count = 0;
            int ent = this.nextPixel();
            int hshift = 0;
            for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
                ++hshift;
            }
            hshift = 8 - hshift;
            int hsize_reg = this.hsize;
            this.cl_hash(hsize_reg);
            this.output(this.ClearCode, outs);
            block1: while ((c = this.nextPixel()) != -1) {
                int i = c << hshift ^ ent;
                fcode = (c << this.maxbits) + ent;
                if (this.htab[i] == fcode) {
                    ent = this.codetab[i];
                    continue;
                }
                if (this.htab[i] >= 0) {
                    int disp = hsize_reg - i;
                    if (i == 0) {
                        disp = 1;
                    }
                    do {
                        if ((i -= disp) < 0) {
                            i += hsize_reg;
                        }
                        if (this.htab[i] != fcode) continue;
                        ent = this.codetab[i];
                        continue block1;
                    } while (this.htab[i] >= 0);
                }
                this.output(ent, outs);
                ent = c;
                if (this.free_ent < this.maxmaxcode) {
                    ++this.free_ent;
                    this.htab[i] = fcode;
                    continue;
                }
                this.cl_block(outs);
            }
            this.output(ent, outs);
            this.output(this.EOFCode, outs);
        }

        void encode(OutputStream os) throws IOException {
            os.write(this.initCodeSize);
            this.remaining = this.imgW * this.imgH;
            this.curPixel = 0;
            this.compress(this.initCodeSize + 1, os);
            os.write(0);
        }

        void flush_char(OutputStream outs) throws IOException {
            if (this.a_count > 0) {
                outs.write(this.a_count);
                outs.write(this.accum, 0, this.a_count);
                this.a_count = 0;
            }
        }

        final int MAXCODE(int n_bits) {
            return (1 << n_bits) - 1;
        }

        private int nextPixel() {
            if (this.remaining == 0) {
                return -1;
            }
            --this.remaining;
            byte pix = this.pixAry[this.curPixel++];
            return pix & 0xFF;
        }

        void output(int code, OutputStream outs) throws IOException {
            this.cur_accum &= this.masks[this.cur_bits];
            this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
            this.cur_bits += this.n_bits;
            while (this.cur_bits >= 8) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            if (this.free_ent > this.maxcode || this.clear_flg) {
                if (this.clear_flg) {
                    this.n_bits = this.g_init_bits;
                    this.maxcode = this.MAXCODE(this.n_bits);
                    this.clear_flg = false;
                } else {
                    ++this.n_bits;
                    this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
                }
            }
            if (code == this.EOFCode) {
                while (this.cur_bits > 0) {
                    this.char_out((byte)(this.cur_accum & 0xFF), outs);
                    this.cur_accum >>= 8;
                    this.cur_bits -= 8;
                }
                this.flush_char(outs);
            }
        }
    }

    private static class NeuQuant {
        protected static final int netsize = 256;
        protected static final int prime1 = 499;
        protected static final int prime2 = 491;
        protected static final int prime3 = 487;
        protected static final int prime4 = 503;
        protected static final int minpicturebytes = 1509;
        protected static final int maxnetpos = 255;
        protected static final int netbiasshift = 4;
        protected static final int ncycles = 100;
        protected static final int intbiasshift = 16;
        protected static final int intbias = 65536;
        protected static final int gammashift = 10;
        protected static final int gamma = 1024;
        protected static final int betashift = 10;
        protected static final int beta = 64;
        protected static final int betagamma = 65536;
        protected static final int initrad = 32;
        protected static final int radiusbiasshift = 6;
        protected static final int radiusbias = 64;
        protected static final int initradius = 2048;
        protected static final int radiusdec = 30;
        protected static final int alphabiasshift = 10;
        protected static final int initalpha = 1024;
        protected int alphadec;
        protected static final int radbiasshift = 8;
        protected static final int radbias = 256;
        protected static final int alpharadbshift = 18;
        protected static final int alpharadbias = 262144;
        protected byte[] thepicture;
        protected int lengthcount;
        protected int samplefac;
        protected int[][] network;
        protected int[] netindex = new int[256];
        protected int[] bias = new int[256];
        protected int[] freq = new int[256];
        protected int[] radpower = new int[32];

        public NeuQuant(byte[] thepic, int len, int sample) {
            this.thepicture = thepic;
            this.lengthcount = len;
            this.samplefac = sample;
            this.network = new int[256][];
            for (int i = 0; i < 256; ++i) {
                this.network[i] = new int[4];
                int[] p = this.network[i];
                p[1] = p[2] = (i << 12) / 256;
                p[0] = p[2];
                this.freq[i] = 256;
                this.bias[i] = 0;
            }
        }

        public byte[] colorMap() {
            byte[] map = new byte[768];
            int[] index = new int[256];
            for (int i = 0; i < 256; ++i) {
                index[this.network[i][3]] = i;
            }
            int k = 0;
            for (int i = 0; i < 256; ++i) {
                int j = index[i];
                map[k++] = (byte)this.network[j][0];
                map[k++] = (byte)this.network[j][1];
                map[k++] = (byte)this.network[j][2];
            }
            return map;
        }

        public void inxbuild() {
            int j;
            int previouscol = 0;
            int startpos = 0;
            for (int i = 0; i < 256; ++i) {
                int[] q;
                int[] p = this.network[i];
                int smallpos = i;
                int smallval = p[1];
                for (j = i + 1; j < 256; ++j) {
                    q = this.network[j];
                    if (q[1] >= smallval) continue;
                    smallpos = j;
                    smallval = q[1];
                }
                q = this.network[smallpos];
                if (i != smallpos) {
                    j = q[0];
                    q[0] = p[0];
                    p[0] = j;
                    j = q[1];
                    q[1] = p[1];
                    p[1] = j;
                    j = q[2];
                    q[2] = p[2];
                    p[2] = j;
                    j = q[3];
                    q[3] = p[3];
                    p[3] = j;
                }
                if (smallval == previouscol) continue;
                this.netindex[previouscol] = startpos + i >> 1;
                for (j = previouscol + 1; j < smallval; ++j) {
                    this.netindex[j] = i;
                }
                previouscol = smallval;
                startpos = i;
            }
            this.netindex[previouscol] = startpos + 255 >> 1;
            for (j = previouscol + 1; j < 256; ++j) {
                this.netindex[j] = 255;
            }
        }

        public void learn() {
            int i;
            if (this.lengthcount < 1509) {
                this.samplefac = 1;
            }
            this.alphadec = 30 + (this.samplefac - 1) / 3;
            byte[] p = this.thepicture;
            int pix = 0;
            int lim = this.lengthcount;
            int samplepixels = this.lengthcount / (3 * this.samplefac);
            int delta = samplepixels / 100;
            int alpha = 1024;
            int radius = 2048;
            int rad = radius >> 6;
            if (rad <= 1) {
                rad = 0;
            }
            for (i = 0; i < rad; ++i) {
                this.radpower[i] = alpha * ((rad * rad - i * i) * 256 / (rad * rad));
            }
            int step = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
            i = 0;
            while (i < samplepixels) {
                int b = (p[pix + 0] & 0xFF) << 4;
                int g = (p[pix + 1] & 0xFF) << 4;
                int r = (p[pix + 2] & 0xFF) << 4;
                int j = this.contest(b, g, r);
                this.altersingle(alpha, j, b, g, r);
                if (rad != 0) {
                    this.alterneigh(rad, j, b, g, r);
                }
                if ((pix += step) >= lim) {
                    pix -= this.lengthcount;
                }
                ++i;
                if (delta == 0) {
                    delta = 1;
                }
                if (i % delta != 0) continue;
                alpha -= alpha / this.alphadec;
                if ((rad = (radius -= radius / 30) >> 6) <= 1) {
                    rad = 0;
                }
                for (j = 0; j < rad; ++j) {
                    this.radpower[j] = alpha * ((rad * rad - j * j) * 256 / (rad * rad));
                }
            }
        }

        public int map(int b, int g, int r) {
            int bestd = 1000;
            int best = -1;
            int i = this.netindex[g];
            int j = i - 1;
            while (i < 256 || j >= 0) {
                int a;
                int dist;
                int[] p;
                if (i < 256) {
                    p = this.network[i];
                    dist = p[1] - g;
                    if (dist >= bestd) {
                        i = 256;
                    } else {
                        ++i;
                        if (dist < 0) {
                            dist = -dist;
                        }
                        if ((a = p[0] - b) < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            a = p[2] - r;
                            if (a < 0) {
                                a = -a;
                            }
                            if ((dist += a) < bestd) {
                                bestd = dist;
                                best = p[3];
                            }
                        }
                    }
                }
                if (j < 0) continue;
                p = this.network[j];
                dist = g - p[1];
                if (dist >= bestd) {
                    j = -1;
                    continue;
                }
                --j;
                if (dist < 0) {
                    dist = -dist;
                }
                if ((a = p[0] - b) < 0) {
                    a = -a;
                }
                if ((dist += a) >= bestd) continue;
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) >= bestd) continue;
                bestd = dist;
                best = p[3];
            }
            return best;
        }

        public byte[] process() {
            this.learn();
            this.unbiasnet();
            this.inxbuild();
            return this.colorMap();
        }

        public void unbiasnet() {
            for (int i = 0; i < 256; ++i) {
                int[] nArray = this.network[i];
                nArray[0] = nArray[0] >> 4;
                int[] nArray2 = this.network[i];
                nArray2[1] = nArray2[1] >> 4;
                int[] nArray3 = this.network[i];
                nArray3[2] = nArray3[2] >> 4;
                this.network[i][3] = i;
            }
        }

        protected void alterneigh(int rad, int i, int b, int g, int r) {
            int hi;
            int lo = i - rad;
            if (lo < -1) {
                lo = -1;
            }
            if ((hi = i + rad) > 256) {
                hi = 256;
            }
            int j = i + 1;
            int k = i - 1;
            int m = 1;
            while (j < hi || k > lo) {
                int[] p;
                int a = this.radpower[m++];
                if (j < hi) {
                    p = this.network[j++];
                    try {
                        p[0] = p[0] - a * (p[0] - b) / 262144;
                        p[1] = p[1] - a * (p[1] - g) / 262144;
                        p[2] = p[2] - a * (p[2] - r) / 262144;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (k <= lo) continue;
                p = this.network[k--];
                try {
                    p[0] = p[0] - a * (p[0] - b) / 262144;
                    p[1] = p[1] - a * (p[1] - g) / 262144;
                    p[2] = p[2] - a * (p[2] - r) / 262144;
                }
                catch (Exception exception) {}
            }
        }

        protected void altersingle(int alpha, int i, int b, int g, int r) {
            int[] n = this.network[i];
            n[0] = n[0] - alpha * (n[0] - b) / 1024;
            n[1] = n[1] - alpha * (n[1] - g) / 1024;
            n[2] = n[2] - alpha * (n[2] - r) / 1024;
        }

        protected int contest(int b, int g, int r) {
            int bestpos;
            int bestd;
            int bestbiasd = bestd = Integer.MAX_VALUE;
            int bestbiaspos = bestpos = -1;
            int i = 0;
            while (i < 256) {
                int biasdist;
                int a;
                int[] n = this.network[i];
                int dist = n[0] - b;
                if (dist < 0) {
                    dist = -dist;
                }
                if ((a = n[1] - g) < 0) {
                    a = -a;
                }
                dist += a;
                a = n[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestd) {
                    bestd = dist;
                    bestpos = i;
                }
                if ((biasdist = dist - (this.bias[i] >> 12)) < bestbiasd) {
                    bestbiasd = biasdist;
                    bestbiaspos = i;
                }
                int betafreq = this.freq[i] >> 10;
                int n2 = i;
                this.freq[n2] = this.freq[n2] - betafreq;
                int n3 = i++;
                this.bias[n3] = this.bias[n3] + (betafreq << 10);
            }
            int n = bestpos;
            this.freq[n] = this.freq[n] + 64;
            int n4 = bestpos;
            this.bias[n4] = this.bias[n4] - 65536;
            return bestbiaspos;
        }
    }
}

