/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import net.creeperhost.ftbbackups.BackupHandler;
import net.creeperhost.ftbbackups.config.Config;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class BackupCommand {
    public static long lastManualBackupTime = 0L;
    public static final SuggestionProvider<CommandSourceStack> SUGGESTIONS = (commandContext, suggestionsBuilder) -> {
        String[] strings = new String[]{"start", "snapshot"};
        return SharedSuggestionProvider.suggest((String[])strings, (SuggestionsBuilder)suggestionsBuilder);
    };

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"backup").requires(cs -> cs.hasPermission(BackupCommand.hasPerm(cs.getServer())))).then(((RequiredArgumentBuilder)Commands.argument((String)"command", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTIONS).executes(cs -> BackupCommand.execute((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"command"), ""))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(cs -> BackupCommand.execute((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"command"), StringArgumentType.getString((CommandContext)cs, (String)"name")))));
    }

    public static int hasPerm(MinecraftServer server) {
        IntegratedServer integratedServer;
        if (server.isDedicatedServer() || server instanceof IntegratedServer && (integratedServer = (IntegratedServer)server).isPublished()) {
            return Config.cached().command_permission_level;
        }
        return 0;
    }

    private static int execute(CommandContext<CommandSourceStack> cs, String command, String name) {
        boolean isProtected = command.toLowerCase(Locale.ROOT).equals("snapshot");
        if (Config.cached().manual_backups_time == 0) {
            BackupHandler.isDirty = true;
            BackupHandler.createBackup(((CommandSourceStack)cs.getSource()).getServer(), isProtected, name);
        } else {
            long configTimeFromMinutes = (long)Config.cached().manual_backups_time * 60000L;
            long lastBackupWithConfig = lastManualBackupTime + configTimeFromMinutes;
            if (System.currentTimeMillis() > lastBackupWithConfig) {
                lastManualBackupTime = System.currentTimeMillis();
                BackupHandler.createBackup(((CommandSourceStack)cs.getSource()).getServer(), isProtected, name);
            } else {
                ((CommandSourceStack)cs.getSource()).sendFailure((Component)Component.literal((String)("Unable to create backup, Last backup was taken less than " + Config.cached().max_backups + " Minutes ago")));
            }
        }
        return 0;
    }
}

