/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixins.features;

import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpringFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpringFeature.class})
public class NoFallsInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void repurposedstructures_noLavaInStructures(FeaturePlaceContext<SpringConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        block6: {
            block5: {
                if (!(context.level() instanceof WorldGenRegion)) {
                    return;
                }
                if (!((SpringConfiguration)context.config()).state.is(FluidTags.LAVA)) break block5;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)context.origin()).move(face);
                    Registry configuredStructureFeatureRegistry = context.level().registryAccess().registryOrThrow(Registries.STRUCTURE);
                    StructureManager structureManager = context.level().getLevel().structureManager();
                    for (Holder structure : configuredStructureFeatureRegistry.getOrCreateTag(RSTags.NO_LAVAFALLS)) {
                        if (!GeneralUtils.getStructureAt((LevelReader)context.level(), structureManager, context.origin(), (Structure)structure.value()).isValid()) continue;
                        cir.setReturnValue((Object)false);
                        return;
                    }
                }
                break block6;
            }
            if (!((SpringConfiguration)context.config()).state.is(FluidTags.WATER)) break block6;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction face : Direction.Plane.HORIZONTAL) {
                mutable.set((Vec3i)context.origin()).move(face);
                Registry configuredStructureFeatureRegistry = context.level().registryAccess().registryOrThrow(Registries.STRUCTURE);
                StructureManager structureManager = context.level().getLevel().structureManager();
                for (Holder structure : configuredStructureFeatureRegistry.getOrCreateTag(RSTags.NO_WATERFALLS)) {
                    if (!GeneralUtils.getStructureAt((LevelReader)context.level(), structureManager, context.origin(), (Structure)structure.value()).isValid()) continue;
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
        }
    }
}

