/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.architectury.event.CompoundEventResult;
import dev.ftb.mods.ftbessentials.api.event.TeleportEvent;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class WarmupCooldownTeleporter {
    private final FTBEPlayerData playerData;
    private final ToIntFunction<ServerPlayer> cooldownConfig;
    private final ToIntFunction<ServerPlayer> warmupConfig;
    private final boolean popHistoryOnTeleport;
    private long cooldown;
    private static final Map<UUID, Warmup> WARMUPS = new HashMap<UUID, Warmup>();
    private static final Map<UUID, Warmup> pendingAdditions = new HashMap<UUID, Warmup>();
    private static final Set<UUID> pendingRemovals = new HashSet<UUID>();

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<ServerPlayer> cooldownConfig, ToIntFunction<ServerPlayer> warmupConfig) {
        this(playerData, cooldownConfig, warmupConfig, false);
    }

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<ServerPlayer> cooldownConfig, ToIntFunction<ServerPlayer> warmupConfig, boolean popHistoryOnTeleport) {
        this.playerData = playerData;
        this.cooldownConfig = cooldownConfig;
        this.warmupConfig = warmupConfig;
        this.popHistoryOnTeleport = popHistoryOnTeleport;
        this.cooldown = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown() {
        long now = System.currentTimeMillis();
        if (now < this.cooldown) {
            return () -> this.cooldown - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    public TeleportPos.TeleportResult teleport(ServerPlayer player, Function<ServerPlayer, TeleportPos> positionGetter) {
        CompoundEventResult<Component> result = ((TeleportEvent.Teleport)TeleportEvent.TELEPORT.invoker()).teleport(player);
        if (result.isFalse()) {
            return TeleportPos.TeleportResult.failed((Component)result.object());
        }
        TeleportPos.TeleportResult cooldownResult = this.checkCooldown();
        if (!cooldownResult.isSuccess()) {
            return cooldownResult;
        }
        int warmupTime = this.warmupConfig.applyAsInt(player);
        if (warmupTime == 0) {
            return this.teleportNow(player, positionGetter);
        }
        pendingAdditions.put(player.getUUID(), new Warmup(System.currentTimeMillis() + (long)warmupTime * 1000L, this, player.position(), positionGetter));
        return TeleportPos.TeleportResult.SUCCESS;
    }

    private TeleportPos.TeleportResult teleportNow(ServerPlayer player, Function<ServerPlayer, TeleportPos> positionGetter) {
        this.cooldown = System.currentTimeMillis() + Math.max(0L, (long)this.cooldownConfig.applyAsInt(player) * 1000L);
        TeleportPos teleportPos = positionGetter.apply(player);
        TeleportPos currentPos = new TeleportPos((Entity)player);
        TeleportPos.TeleportResult res = teleportPos.teleport(player);
        if (res.isSuccess()) {
            if (this.popHistoryOnTeleport) {
                this.playerData.popTeleportHistory();
            } else if (!((Boolean)FTBEConfig.BACK_ON_DEATH_ONLY.get()).booleanValue()) {
                this.playerData.addTeleportHistory(player, currentPos);
            }
        }
        return res;
    }

    public static void tickWarmups(MinecraftServer server) {
        WARMUPS.putAll(pendingAdditions);
        pendingAdditions.clear();
        pendingRemovals.forEach(WARMUPS::remove);
        pendingRemovals.clear();
        if (WARMUPS.isEmpty()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Warmup> entry : WARMUPS.entrySet()) {
            UUID playerId = entry.getKey();
            ServerPlayer player = server.getPlayerList().getPlayer(playerId);
            if (player != null) {
                Warmup warmup = entry.getValue();
                if (warmup.when() <= now) {
                    TeleportPos.TeleportResult res = warmup.teleporter().teleportNow(player, warmup.positionGetter());
                    toRemove.add(playerId);
                    res.runCommand(player);
                    continue;
                }
                if (player.position().distanceToSqr(warmup.initialPos) > 0.25) {
                    toRemove.add(playerId);
                    player.displayClientMessage((Component)Component.literal((String)"Teleportation interrupted!").withStyle(ChatFormatting.RED), true);
                    continue;
                }
                long seconds = (warmup.when() - now) / 1000L;
                String secStr = seconds == 1L ? "second" : "seconds";
                player.displayClientMessage((Component)Component.literal((String)String.format("Teleporting in %d %s", seconds, secStr)).withStyle(ChatFormatting.YELLOW), true);
                continue;
            }
            toRemove.add(playerId);
        }
        toRemove.forEach(WARMUPS::remove);
    }

    public static void cancelWarmup(ServerPlayer player) {
        if (WARMUPS.containsKey(player.getUUID())) {
            pendingRemovals.add(player.getUUID());
            player.displayClientMessage((Component)Component.literal((String)"Teleportation interrupted!").withStyle(ChatFormatting.RED), true);
        }
    }

    private record Warmup(long when, WarmupCooldownTeleporter teleporter, Vec3 initialPos, Function<ServerPlayer, TeleportPos> positionGetter) {
    }
}

