/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.kit;

import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;

public enum KitManager {
    INSTANCE;

    private final Map<String, Kit> allKits = new HashMap<String, Kit>();

    public static KitManager getInstance() {
        return INSTANCE;
    }

    public void load(CompoundTag kits, HolderLookup.Provider provider) {
        this.allKits.clear();
        kits.getAllKeys().forEach(key -> this.allKits.put((String)key, Kit.fromNBT(key, kits.getCompound(key), provider)));
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.allKits.forEach((name, kit) -> tag.put(name, (Tag)kit.toNBT(provider))));
    }

    public Optional<Kit> get(String kitName) {
        return Optional.ofNullable(this.allKits.get(kitName));
    }

    public Collection<Kit> allKits() {
        return Collections.unmodifiableCollection(this.allKits.values());
    }

    public void giveKitToPlayer(String kitName, ServerPlayer player) {
        FTBEPlayerData.getOrCreate((Player)player).ifPresent(playerData -> this.get(kitName).ifPresentOrElse(kit -> kit.giveToPlayer(player, (FTBEPlayerData)playerData, true), () -> {
            throw new IllegalArgumentException("Kit '" + kitName + "' does not exist");
        }));
    }

    public void deleteKit(String kitName) {
        Validate.isTrue((boolean)this.allKits.containsKey(kitName), (String)("Kit '" + kitName + "' does not exist"), (Object[])new Object[0]);
        this.allKits.remove(kitName);
        FTBEPlayerData.cleanupKitCooldowns(kitName);
        FTBEWorldData.instance.markDirty();
    }

    public void createFromPlayerInv(String kitName, ServerPlayer player, long cooldownSecs, boolean hotbarOnly) {
        if (hotbarOnly) {
            NonNullList items = NonNullList.create();
            for (int i = 0; i < 9; ++i) {
                items.add((Object)((ItemStack)player.getInventory().items.get(i)));
            }
            this.createKit(kitName, cooldownSecs, () -> items);
        } else {
            this.createKit(kitName, cooldownSecs, () -> player.getInventory().items);
        }
    }

    public void createFromBlockInv(String kitName, Level level, BlockPos pos, Direction side, long cooldownSecs) {
        this.createKit(kitName, cooldownSecs, () -> InventoryUtil.getItemsInInventory(level, pos, side));
    }

    private void createKit(String kitName, long cooldownSecs, Supplier<NonNullList<ItemStack>> itemSupplier) {
        List<ItemStack> items = itemSupplier.get().stream().filter(stack -> !stack.isEmpty()).map(ItemStack::copy).toList();
        if (items.isEmpty()) {
            throw new IllegalArgumentException("No items found!");
        }
        this.addKit(new Kit(kitName, items, cooldownSecs, false), false);
    }

    public void addKit(Kit kit, boolean overwrite) {
        if (!overwrite) {
            Validate.isTrue((!this.allKits.containsKey(kit.getKitName()) ? 1 : 0) != 0, (String)("Kit '" + kit.getKitName() + "' already exists"), (Object[])new Object[0]);
        }
        this.allKits.put(kit.getKitName(), kit);
        FTBEWorldData.instance.markDirty();
    }
}

