/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.kit;

import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class Kit {
    private final String kitName;
    private final List<ItemStack> items;
    private final long cooldown;
    private final boolean autoGrant;

    public Kit(String kitName, Collection<ItemStack> items, long cooldown, boolean autoGrant) {
        this.kitName = kitName;
        this.items = List.copyOf(items);
        this.cooldown = cooldown;
        this.autoGrant = autoGrant;
    }

    public static Kit deepCopy(String kitName, Collection<ItemStack> items, long cooldownSecs, boolean autoGrant) {
        return new Kit(kitName, items.stream().map(ItemStack::copy).toList(), cooldownSecs, autoGrant);
    }

    public String getKitName() {
        return this.kitName;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public boolean isAutoGrant() {
        return this.autoGrant;
    }

    public CompoundTag toNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.items.forEach(stack -> list.add((Object)this.saveStack((ItemStack)stack, provider)));
        tag.put("items", (Tag)list);
        tag.putLong("cooldown", this.cooldown);
        if (this.autoGrant) {
            tag.putBoolean("auto_grant", true);
        }
        return tag;
    }

    private SNBTCompoundTag saveStack(ItemStack stack, HolderLookup.Provider provider) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        stack.save(provider, (Tag)tag);
        return tag;
    }

    public static Kit fromNBT(String kitName, CompoundTag tag, HolderLookup.Provider provider) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag list = tag.getList("items", 10);
        list.forEach(el -> {
            if (el instanceof CompoundTag) {
                CompoundTag c = (CompoundTag)el;
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)c).ifPresent(items::add);
            }
        });
        return new Kit(kitName, items, tag.getLong("cooldown"), tag.getBoolean("auto_grant"));
    }

    public void giveToPlayer(ServerPlayer player, FTBEPlayerData playerData, boolean throwOnCooldown) {
        long now = System.currentTimeMillis();
        if (!this.checkForCooldown(player, playerData, now, throwOnCooldown)) {
            this.items.forEach(stack -> {
                ItemEntity itementity;
                ItemStack stack1 = stack.copy();
                if (!player.getInventory().add(stack1) && (itementity = player.drop(stack1, false)) != null) {
                    itementity.setNoPickUpDelay();
                    itementity.setTarget(player.getUUID());
                }
            });
            if (this.cooldown != 0L) {
                playerData.setLastKitUseTime(this.kitName, now);
            }
        }
    }

    private boolean checkForCooldown(ServerPlayer player, FTBEPlayerData data, long now, boolean throwOnCooldown) {
        if (this.cooldown != 0L) {
            long lastUsed = data.getLastKitUseTime(this.kitName);
            if (this.cooldown < 0L && lastUsed != 0L) {
                if (throwOnCooldown) {
                    throw new IllegalStateException("Kit " + this.kitName + " is a one-time use kit (already given to " + player.getGameProfile().getName() + ")");
                }
                return true;
            }
            long delta = (now - lastUsed) / 1000L;
            if (delta < this.cooldown) {
                if (throwOnCooldown) {
                    long remaining = this.cooldown - delta;
                    throw new IllegalStateException("Kit " + this.kitName + " is on cooldown - " + TimeUtils.prettyTimeString((long)remaining) + " remaining");
                }
                return true;
            }
        }
        return false;
    }

    public Kit withCooldown(long newCooldown) {
        return new Kit(this.kitName, this.items, newCooldown, this.autoGrant);
    }

    public Kit withAutoGrant(boolean newAutoGrant) {
        return new Kit(this.kitName, this.items, this.cooldown, newAutoGrant);
    }
}

