/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HomeCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.HOME.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.home(((CommandSourceStack)context.getSource()).getPlayerOrException(), "home"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(this.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> this.home(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sethome").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.setHome(((CommandSourceStack)context.getSource()).getPlayerOrException(), "home"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setHome(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delhome").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.delHome(((CommandSourceStack)context.getSource()).getPlayerOrException(), "home"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(this.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> this.delHome(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listhomes").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommand.listHomes((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException().getGameProfile()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).requires(source -> source.getServer().isSingleplayer() || source.hasPermission(2))).executes(context -> HomeCommand.listHomes((CommandSourceStack)context.getSource(), (GameProfile)GameProfileArgument.getGameProfiles((CommandContext)context, (String)"player").iterator().next()))));
    }

    public Set<String> getHomeSuggestions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return FTBEPlayerData.getOrCreate((Player)((CommandSourceStack)context.getSource()).getPlayerOrException()).map(data -> data.homeManager().getNames()).orElse(Set.of());
    }

    public int home(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> data.homeManager().teleportTo(name, player, data.homeTeleporter).runCommand(player)).orElse(0);
    }

    public int setHome(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            try {
                data.homeManager().addDestination(name, new TeleportPos((Entity)player), player);
                player.displayClientMessage((Component)Component.literal((String)"Home set!"), false);
                return 1;
            }
            catch (SavedTeleportManager.TooManyDestinationsException e) {
                player.displayClientMessage((Component)Component.literal((String)"Can't add any more homes!"), false);
                return 0;
            }
        }).orElse(0);
    }

    public int delHome(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            if (data.homeManager().deleteDestination(name.toLowerCase())) {
                player.displayClientMessage((Component)Component.literal((String)"Home deleted!"), false);
                return 1;
            }
            player.displayClientMessage((Component)Component.literal((String)"Home not found!"), false);
            return 0;
        }).orElse(0);
    }

    public static int listHomes(CommandSourceStack source, GameProfile of) {
        return FTBEPlayerData.getOrCreate(source.getServer(), of.getId()).map(data -> {
            if (data.homeManager().getNames().isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"None"), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)("Homes for " + of.getName() + "\n---")).withStyle(ChatFormatting.GOLD), false);
                TeleportPos origin = new TeleportPos((ResourceKey<Level>)source.getLevel().dimension(), BlockPos.containing((Position)source.getPosition()));
                data.homeManager().destinations().forEach(entry -> source.sendSuccess(() -> {
                    MutableComponent literal = Component.empty().append((Component)Component.literal((String)entry.name()).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD)).append((Component)Component.literal((String)(": " + entry.destination().distanceString(origin) + " away")));
                    if (source.hasPermission(2)) {
                        literal.withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp @s " + entry.destination().posAsString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to teleport"))));
                    }
                    return literal;
                }, false));
            }
            return 1;
        }).orElse(0);
    }
}

