/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.chat;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class MuteCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.MUTE.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> this.mute((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), ""))).then(Commands.argument((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandUtils.suggestDurations(builder)).executes(context -> this.mute((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> this.unmute((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))));
    }

    private int mute(CommandSourceStack source, ServerPlayer player, String duration) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            try {
                DurationInfo info = DurationInfo.fromString(duration);
                data.setMuted(true);
                FTBEWorldData.instance.setMuteTimeout(player, info.until());
                MutableComponent msg = player.getDisplayName().copy().append(" has been muted by ").append(source.getDisplayName()).append(", ").append(info.desc());
                this.notifyMuting(source, (Player)player, (Component)msg);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("Invalid duration syntax: '" + duration + "': " + e.getMessage())));
                return 0;
            }
        }).orElse(0);
    }

    private int unmute(CommandSourceStack source, ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setMuted(false);
            FTBEWorldData.instance.setMuteTimeout(player, -1L);
            MutableComponent msg = player.getDisplayName().copy().append(" has been unmuted by ").append(source.getDisplayName());
            this.notifyMuting(source, (Player)player, (Component)msg);
            return 1;
        }).orElse(0);
    }

    private void notifyMuting(CommandSourceStack source, Player target, Component msg) {
        source.getServer().getPlayerList().getPlayers().forEach(p -> {
            if (p.hasPermissions(2) || p == target) {
                p.displayClientMessage(msg, false);
            }
        });
        if (!source.isPlayer()) {
            source.sendSuccess(() -> msg, true);
        }
    }
}

