/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.groups;

import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.SimpleCommandPlayer;
import dev.ftb.mods.ftbessentials.commands.impl.cheat.SpeedCommand;
import dev.ftb.mods.ftbessentials.commands.impl.cheat.VirtualInventoryCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;

public class CheatCommands {
    public static final List<FTBCommand> COMMANDS = List.of(SimpleCommandPlayer.create("heal", 2, FTBEConfig.HEAL, (ctx, player) -> CheatCommands.heal(player)), SimpleCommandPlayer.create("feed", 2, FTBEConfig.FEED, (ctx, player) -> player.getFoodData().eat(40, 40.0f)), SimpleCommandPlayer.create("extinguish", 2, FTBEConfig.EXTINGUISH, (ctx, player) -> player.clearFire()), SimpleCommandPlayer.create("fly", 2, FTBEConfig.FLY, (ctx, player) -> CheatCommands.fly(player)), SimpleCommandPlayer.create("god", 2, FTBEConfig.GOD, (ctx, player) -> CheatCommands.god(player)), new SpeedCommand(), new VirtualInventoryCommand(), new SimpleCommandPlayer("enderchest", 2, FTBEConfig.ENDER_CHEST, CheatCommands::enderChest));

    private static void enderChest(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        MutableComponent title = Component.translatable((String)"container.enderchest");
        ServerPlayer srcPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (player != null && srcPlayer != null) {
            title.append(" \u00d7 ").append(player.getDisplayName());
            srcPlayer.openMenu((MenuProvider)new SimpleMenuProvider((i, inv, p) -> ChestMenu.threeRows((int)i, (Inventory)inv, (Container)player.getEnderChestInventory()), (Component)title));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Unable to open enderchest inventory!"));
        }
    }

    public static void heal(ServerPlayer player) {
        player.setHealth(player.getMaxHealth());
        player.getFoodData().eat(40, 40.0f);
        player.clearFire();
        FTBEssentialsPlatform.curePotionEffects(player);
    }

    private static void fly(ServerPlayer player) {
        FTBEPlayerData.getOrCreate((Player)player).ifPresent(data -> {
            Abilities abilities = player.getAbilities();
            if (data.canFly()) {
                data.setCanFly(false);
                abilities.mayfly = false;
                abilities.flying = false;
                player.displayClientMessage((Component)Component.literal((String)"Flight disabled"), true);
            } else {
                data.setCanFly(true);
                abilities.mayfly = true;
                player.displayClientMessage((Component)Component.literal((String)"Flight enabled"), true);
            }
            player.onUpdateAbilities();
        });
    }

    private static void god(ServerPlayer player) {
        FTBEPlayerData.getOrCreate((Player)player).ifPresent(data -> {
            Abilities abilities = player.getAbilities();
            if (data.isGod()) {
                data.setGod(false);
                abilities.invulnerable = false;
                player.displayClientMessage((Component)Component.literal((String)"God mode disabled"), true);
            } else {
                data.setGod(true);
                abilities.invulnerable = true;
                player.displayClientMessage((Component)Component.literal((String)"God mode enabled"), true);
            }
            player.onUpdateAbilities();
        });
    }
}

