/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.event;

import java.util.function.Function;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import org.jetbrains.annotations.Nullable;

public final class ModelLoadingHelper {
    @Nullable
    private static BlockStateModelLoader blockStateModelLoader;

    private ModelLoadingHelper() {
    }

    public static void setBlockStateModelLoader(BlockStateModelLoader blockStateModelLoader) {
        ModelLoadingHelper.blockStateModelLoader = blockStateModelLoader;
    }

    public static Function<ModelResourceLocation, UnbakedModel> getUnbakedTopLevelModel(ModelBakery modelBakery) {
        return modelResourceLocation -> ModelLoadingHelper.getUnbakedTopLevelModel(modelBakery, modelResourceLocation);
    }

    private static UnbakedModel getUnbakedTopLevelModel(ModelBakery modelBakery, ModelResourceLocation modelResourceLocation) {
        UnbakedModel unbakedModel = (UnbakedModel)modelBakery.topLevelModels.get(modelResourceLocation);
        if (unbakedModel == null && blockStateModelLoader != null) {
            unbakedModel = ModelLoadingHelper.loadUnbakedBlockStateModel(modelBakery, blockStateModelLoader, modelResourceLocation);
        } else if (unbakedModel != null) {
            unbakedModel.resolveParents(arg_0 -> ((ModelBakery)modelBakery).getModel(arg_0));
        }
        if (unbakedModel == null) {
            return (UnbakedModel)modelBakery.topLevelModels.get(ModelBakery.MISSING_MODEL_VARIANT);
        }
        return unbakedModel;
    }

    @Nullable
    public static UnbakedModel loadUnbakedBlockStateModel(ModelBakery modelBakery, BlockStateModelLoader blockStateModelLoader, ModelResourceLocation modelResourceLocation) {
        return BuiltInRegistries.BLOCK.getOptional(modelResourceLocation.id()).map(block -> {
            blockStateModelLoader.loadBlockStateDefinitions(modelResourceLocation.id(), block.getStateDefinition());
            UnbakedModel unbakedModel = (UnbakedModel)modelBakery.topLevelModels.get(modelResourceLocation);
            if (unbakedModel != null) {
                unbakedModel.resolveParents(arg_0 -> ((ModelBakery)modelBakery).getModel(arg_0));
            }
            return unbakedModel;
        }).orElse(null);
    }
}

