/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.init.v3.override.CommandOverrides;
import fuzs.puzzleslib.api.init.v3.override.GameRuleValueOverrides;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.capability.ClientboundEntityCapabilityMessage;
import fuzs.puzzleslib.impl.core.ClientboundModListMessage;
import fuzs.puzzleslib.impl.core.EventHandlerProvider;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.GameRules;

public class PuzzlesLibMod
extends PuzzlesLib
implements ModConstructor {
    public static final NetworkHandler NETWORK = NetworkHandler.builder("puzzleslib").optional().registerClientbound(ClientboundEntityCapabilityMessage.class).registerClientbound(ClientboundModListMessage.class);

    @Override
    public void onConstructMod() {
        PuzzlesLibMod.registerEventHandlers();
        PuzzlesLibMod.setupDevelopmentEnvironment();
    }

    private static void registerEventHandlers() {
        ModContext.registerEventHandlers();
        EventHandlerProvider.tryRegister(CommonAbstractions.INSTANCE);
        LoadCompleteCallback.EVENT.register(EventInvokerImpl::initialize);
    }

    private static void setupDevelopmentEnvironment() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment() || ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        CommandOverrides.registerHandlers();
        PuzzlesLibMod.initializeGameRules();
        PuzzlesLibMod.initializeCommands();
    }

    private static void initializeCommands() {
        CommandOverrides.registerServerCommand("time set 4000", false);
        CommandOverrides.registerPlayerCommand("op @s", true);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.NIGHT_VISION);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.DAMAGE_BOOST);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.WATER_BREATHING);
    }

    private static void initializeGameRules() {
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DAYLIGHT, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_WEATHER_CYCLE, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_KEEPINVENTORY, true);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DOFIRETICK, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOBGRIEFING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DOINSOMNIA, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_PATROL_SPAWNING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_TRADER_SPAWNING, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_DO_VINES_SPREAD, false);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.IntegerValue>)GameRules.RULE_MAX_ENTITY_CRAMMING, 0);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.IntegerValue>)GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY, 1);
        GameRuleValueOverrides.setValue((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_COMMANDBLOCKOUTPUT, false);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath("puzzleslib", path);
    }
}

