/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.item.CreativeModeTabConfiguratorImpl;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface CreativeModeTabConfigurator {
    public static CreativeModeTabConfigurator from(String modId, Holder<? extends ItemLike> icon) {
        return CreativeModeTabConfigurator.from(modId).icon(icon);
    }

    @Deprecated(forRemoval=true)
    public static CreativeModeTabConfigurator from(String modId, Supplier<ItemStack> icon) {
        return CreativeModeTabConfigurator.from(modId).icon(icon);
    }

    public static CreativeModeTabConfigurator from(String modId) {
        return CreativeModeTabConfigurator.from(modId, "main");
    }

    public static CreativeModeTabConfigurator from(String modId, String tabId) {
        return CreativeModeTabConfigurator.from(ResourceLocationHelper.fromNamespaceAndPath(modId, tabId));
    }

    public static CreativeModeTabConfigurator from(ResourceLocation resourceLocation) {
        return new CreativeModeTabConfiguratorImpl(resourceLocation);
    }

    default public CreativeModeTabConfigurator icon(Holder<? extends ItemLike> icon) {
        return this.icon(() -> new ItemStack((ItemLike)icon.value()));
    }

    public CreativeModeTabConfigurator icon(Supplier<ItemStack> var1);

    public CreativeModeTabConfigurator icons(Supplier<ItemStack[]> var1);

    public CreativeModeTabConfigurator displayItems(CreativeModeTab.DisplayItemsGenerator var1);

    public CreativeModeTabConfigurator withSearchBar();

    public CreativeModeTabConfigurator appendEnchantmentsAndPotions();
}

