/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.cottonly.datagenerators;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.manmaed.cottonly.datagenerators.CottonBlockLootTables;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class CottonLootTables
extends LootTableProvider {
    public CottonLootTables(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(CottonBlockLootTables::new, LootContextParamSets.BLOCK)), completableFuture);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        Set cottonLootTablesId = BuiltInLootTables.all().stream().filter(id -> id.registry().getNamespace().equals("cottonly")).collect(Collectors.toSet());
        for (ResourceKey id2 : Sets.difference(cottonLootTablesId, (Set)writableregistry.keySet())) {
            validationcontext.reportProblem("Missing built-in table: " + String.valueOf(id2));
        }
        writableregistry.forEach(lootTable -> lootTable.validate(validationcontext));
    }
}

