/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.cottonly.datagenerators;

import java.util.concurrent.CompletableFuture;
import net.manmaed.cottonly.items.CItems;
import net.manmaed.cottonly.loot.FernModifier;
import net.manmaed.cottonly.loot.LargeFernModifier;
import net.manmaed.cottonly.loot.ShortGrassModifier;
import net.manmaed.cottonly.loot.TallGrassModifier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class CottonGlobalLootModifierProvider
extends GlobalLootModifierProvider {
    private Float seedChance = Float.valueOf(0.1f);
    private ItemStack cotton = new ItemStack((ItemLike)CItems.COTTON_SEED.get());

    public CottonGlobalLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture, "cottonly");
    }

    protected void start() {
        this.add("cotton_from_short_grass", (IGlobalLootModifier)new ShortGrassModifier(CottonGlobalLootModifierProvider.lootItemConditions(this.seedChance.floatValue(), this.getMCLoc("short_grass")), this.cotton), new ICondition[0]);
        this.add("cotton_from_tall_grass", (IGlobalLootModifier)new TallGrassModifier(CottonGlobalLootModifierProvider.lootItemConditions(this.seedChance.floatValue(), this.getMCLoc("tall_grass")), this.cotton), new ICondition[0]);
        this.add("cotton_from_fern", (IGlobalLootModifier)new FernModifier(CottonGlobalLootModifierProvider.lootItemConditions(this.seedChance.floatValue(), this.getMCLoc("fern")), this.cotton), new ICondition[0]);
        this.add("cotton_from_large_fern", (IGlobalLootModifier)new LargeFernModifier(CottonGlobalLootModifierProvider.lootItemConditions(this.seedChance.floatValue(), this.getMCLoc("large_fern")), this.cotton), new ICondition[0]);
    }

    private ResourceLocation getMCLoc(String block_name) {
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("blocks/" + block_name));
    }

    private static LootItemCondition[] lootItemConditions(float chance, ResourceLocation table) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), LootTableIdCondition.builder((ResourceLocation)table).build()};
    }
}

