/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.setup.Registration;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import mcjty.rftoolspower.modules.dimensionalcell.data.DimensionalCellData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DimensionalCellBlock
extends BaseBlock
implements IComponentsToPreserve {
    public static final EnumProperty<DimensionalCellTileEntity.Mode> NORTH = EnumProperty.create((String)"north", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> SOUTH = EnumProperty.create((String)"south", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> WEST = EnumProperty.create((String)"west", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> EAST = EnumProperty.create((String)"east", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> UP = EnumProperty.create((String)"up", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> DOWN = EnumProperty.create((String)"down", DimensionalCellTileEntity.Mode.class);
    private final DimensionalCellType type;
    private static final VoxelShape RENDER_SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public DimensionalCellType getType() {
        return this.type;
    }

    @Nonnull
    public VoxelShape getOcclusionShape(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return RENDER_SHAPE;
    }

    public static DimensionalCellType getType(Block block) {
        if (block instanceof DimensionalCellBlock) {
            return ((DimensionalCellBlock)block).getType();
        }
        return DimensionalCellType.UNKNOWN;
    }

    public DimensionalCellBlock(DimensionalCellType type, BlockEntityType.BlockEntitySupplier<BlockEntity> supplier) {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).isRedstoneConductor((state, world, pos) -> false)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).tileEntitySupplier(supplier).infusable().manualEntry(ManualHelper.create((String)"rftoolsbase:powerstorage/dimensionalcell")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> {
            String energy = String.valueOf(DimensionalCellBlock.getEnergy(stack));
            String max = String.valueOf((Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * DimensionalCellBlock.getPowerFactor(type) / (Integer)DimensionalCellConfiguration.simpleFactor.get());
            return energy + " (max " + max + " RF/FE)";
        })}));
        this.type = type;
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA.get(), (DataComponentType)Registration.ITEM_INFUSABLE.get(), (DataComponentType)Registration.ITEM_INVENTORY.get());
    }

    private static int getPowerFactor(DimensionalCellType type) {
        if (type.isSimple()) {
            return 1;
        }
        return type.isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    protected boolean wrenchSneakSelect(Level world, BlockPos pos, Player player) {
        BlockEntity te;
        SmartWrenchMode currentMode;
        if (!world.isClientSide && (currentMode = SmartWrenchItem.getCurrentMode((ItemStack)player.getItemInHand(InteractionHand.MAIN_HAND))) == SmartWrenchMode.MODE_SELECT && (te = world.getBlockEntity(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity cell = (DimensionalCellTileEntity)te;
            DimensionalCellTileEntity.dumpNetwork(player, cell);
        }
        return true;
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity cell = (DimensionalCellTileEntity)te;
            cell.toggleMode(side);
        }
        return true;
    }

    private static int getEnergy(ItemStack stack) {
        DimensionalCellData data = (DimensionalCellData)stack.get(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA);
        return data == null ? 0 : data.energy();
    }

    private static void setEnergy(ItemStack stack, int energy) {
        DimensionalCellData data = (DimensionalCellData)stack.get(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA);
        data = data == null ? new DimensionalCellData(energy, 0L, 0L, -1) : data.withEnergy(energy);
        stack.set(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA, (Object)data);
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            if (stack.get(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA) == null) {
                DimensionalCellTileEntity dimensionalCellTileEntity = (DimensionalCellTileEntity)world.getBlockEntity(pos);
                if (dimensionalCellTileEntity != null && this.type.isCreative()) {
                    dimensionalCellTileEntity.setAllOutput();
                }
            } else {
                int networkId;
                DimensionalCellTileEntity dimensionalCellTileEntity = (DimensionalCellTileEntity)world.getBlockEntity(pos);
                if (dimensionalCellTileEntity != null && (networkId = dimensionalCellTileEntity.getNetworkId()) != -1) {
                    int energy = DimensionalCellBlock.getEnergy(stack);
                    DimensionalCellNetwork dimensionalCellNetwork = DimensionalCellNetwork.get(world);
                    DimensionalCellNetwork.Network network = dimensionalCellNetwork.getChannel(networkId);
                    network.receiveEnergy(energy);
                    Block block = world.getBlockState(pos).getBlock();
                    network.add(world, dimensionalCellTileEntity.getGlobalPos(), DimensionalCellBlock.getType(block));
                    dimensionalCellNetwork.save();
                }
            }
        }
        if (placer instanceof Player) {
            // empty if block
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        System.out.println("DimensionalCellBlock.getDrops");
        ServerLevel world = builder.getLevel();
        Vec3 pos = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
        List drops = super.getDrops(state, builder);
        if (!world.isClientSide && (te = world.getBlockEntity(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z))) instanceof DimensionalCellTileEntity && (network = ((DimensionalCellTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergySingleBlock(this.getType());
            System.out.println("getDrops: energy = " + energy);
            if (!drops.isEmpty()) {
                DimensionalCellBlock.setEnergy((ItemStack)drops.get(0), energy);
            }
        }
        return drops;
    }

    public void wasExploded(Level world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        DimensionalCellTileEntity cell;
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof DimensionalCellTileEntity && (network = (cell = (DimensionalCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.type);
            Block block = world.getBlockState(pos).getBlock();
            network.remove(world, cell.getGlobalPos(), DimensionalCellBlock.getType(block));
            DimensionalCellNetwork.get(world).save();
            cell.setNetworkId(-1);
        }
        super.wasExploded(world, pos, explosion);
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        DimensionalCellTileEntity cell;
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        if (!world.isClientSide && state.getBlock() != newstate.getBlock() && (te = world.getBlockEntity(pos)) instanceof DimensionalCellTileEntity && (network = (cell = (DimensionalCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.type);
            System.out.println("a = " + a);
            Block block = world.getBlockState(pos).getBlock();
            network.remove(world, cell.getGlobalPos(), DimensionalCellBlock.getType(block));
            DimensionalCellNetwork.get(world).save();
        }
        super.onRemove(state, world, pos, newstate, isMoving);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }
}

