/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import org.jetbrains.annotations.Nullable;

public final class ReactionChamberRecipes {
    private ReactionChamberRecipes() {
    }

    public static Iterable<RecipeHolder<ReactionChamberRecipe>> getRecipes(Level level) {
        return level.getRecipeManager().byType(ReactionChamberRecipe.TYPE);
    }

    @Nullable
    public static ReactionChamberRecipe findRecipe(Level level, List<ItemStack> inputs, GenericStack fluid) {
        ArrayList<ItemStack> machineInputs = new ArrayList<ItemStack>();
        for (ItemStack itemStack : inputs) {
            if (itemStack.isEmpty()) continue;
            machineInputs.add(itemStack);
        }
        for (RecipeHolder recipeHolder : ReactionChamberRecipes.getRecipes(level)) {
            ReactionChamberRecipe recipe = (ReactionChamberRecipe)recipeHolder.value();
            List<IngredientStack<?, ?>> validInputs = recipe.getValidInputs();
            boolean failed = false;
            for (IngredientStack<?, ?> input : validInputs) {
                boolean found = false;
                for (ItemStack machineInput : machineInputs) {
                    if (!input.checkType((Object)machineInput) || !((Ingredient)((IngredientStack.Item)input).getIngredient()).test(machineInput) || input.getAmount() > machineInput.getCount()) continue;
                    found = true;
                    break;
                }
                if (input instanceof IngredientStack.Fluid) {
                    AEKey aEKey;
                    IngredientStack.Fluid fluidIn = (IngredientStack.Fluid)input;
                    if (fluid != null && (aEKey = fluid.what()) instanceof AEFluidKey) {
                        AEFluidKey key = (AEFluidKey)aEKey;
                        FluidStack fluidStack = key.toStack((int)fluid.amount());
                        if (((FluidIngredient)fluidIn.getIngredient()).test(fluidStack)) {
                            found = true;
                        }
                    }
                }
                if (found) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack stack, Level level) {
        for (RecipeHolder<ReactionChamberRecipe> holder : ReactionChamberRecipes.getRecipes(level)) {
            ReactionChamberRecipe recipe = (ReactionChamberRecipe)holder.value();
            if (!recipe.containsIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidIngredient(FluidStack stack, Level level) {
        for (RecipeHolder<ReactionChamberRecipe> holder : ReactionChamberRecipes.getRecipes(level)) {
            ReactionChamberRecipe recipe = (ReactionChamberRecipe)holder.value();
            if (!recipe.containsIngredient(stack)) continue;
            return true;
        }
        return false;
    }
}

