/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins.cpu;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.crafting.ICraftingWatcherNode;
import appeng.api.networking.crafting.UnsuitableCpus;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.crafting.CraftingLink;
import appeng.crafting.execution.CraftingSubmitResult;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.InterestManager;
import appeng.me.helpers.StackWatcher;
import appeng.me.service.CraftingService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPU;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingService.class}, remap=false)
public class MixinCraftingService {
    @Unique
    private static final Comparator<AdvCraftingCPUCluster> FAST_FIRST_COMPARATOR = Comparator.comparingInt(AdvCraftingCPUCluster::getCoProcessors).reversed().thenComparingLong(AdvCraftingCPUCluster::getAvailableStorage);
    @Unique
    private final Set<AdvCraftingCPUCluster> advancedAE$advCraftingCPUClusters = new HashSet<AdvCraftingCPUCluster>();
    @Final
    @Shadow
    private IGrid grid;
    @Final
    @Shadow
    private InterestManager<StackWatcher<ICraftingWatcherNode>> interestManager;
    @Final
    @Shadow
    private IEnergyService energyGrid;
    @Final
    @Shadow
    private Set<AEKey> currentlyCrafting;
    @Shadow
    private boolean updateList;

    @Shadow
    public void addLink(CraftingLink link) {
    }

    @Inject(method={"onServerEndTick"}, at={@At(value="TAIL")})
    private void tickAdvClusters(CallbackInfo ci) {
        Set<AEKey> previouslyCrafting = this.currentlyCrafting;
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            for (AdvCraftingCPU cpu : cluster.getActiveCPUs()) {
                cpu.craftingLogic.tickCraftingLogic(this.energyGrid, (CraftingService)this);
                cpu.craftingLogic.getAllWaitingFor(this.currentlyCrafting);
            }
        }
        HashSet changed = new HashSet();
        changed.addAll(Sets.difference(previouslyCrafting, this.currentlyCrafting));
        changed.addAll(Sets.difference(this.currentlyCrafting, previouslyCrafting));
        for (AEKey what : changed) {
            for (StackWatcher watcher : this.interestManager.get(what)) {
                ((ICraftingWatcherNode)watcher.getHost()).onRequestChange(what);
            }
            for (StackWatcher watcher : this.interestManager.getAllStacksWatchers()) {
                ((ICraftingWatcherNode)watcher.getHost()).onRequestChange(what);
            }
        }
    }

    @Inject(method={"removeNode"}, at={@At(value="TAIL")})
    private void onRemoveNode(IGridNode gridNode, CallbackInfo ci) {
        if (gridNode.getOwner() instanceof AdvCraftingBlockEntity) {
            this.updateList = true;
        }
    }

    @Inject(method={"addNode"}, at={@At(value="TAIL")})
    private void onAddNode(IGridNode gridNode, CompoundTag savedData, CallbackInfo ci) {
        if (gridNode.getOwner() instanceof AdvCraftingBlockEntity) {
            this.updateList = true;
        }
    }

    @Inject(method={"updateCPUClusters"}, at={@At(value="TAIL")})
    private void onUpdateCPUClusters(CallbackInfo ci) {
        this.advancedAE$advCraftingCPUClusters.clear();
        for (AdvCraftingBlockEntity blockEntity : this.grid.getMachines(AdvCraftingBlockEntity.class)) {
            AdvCraftingCPUCluster cluster = blockEntity.getCluster();
            if (cluster == null) continue;
            this.advancedAE$advCraftingCPUClusters.add(cluster);
            for (AdvCraftingCPU cpu : cluster.getActiveCPUs()) {
                ICraftingLink maybeLink = cpu.craftingLogic.getLastLink();
                if (maybeLink == null) continue;
                this.addLink((CraftingLink)maybeLink);
            }
        }
    }

    @Inject(method={"insertIntoCpus"}, at={@At(value="RETURN")}, cancellable=true)
    private void onInsertIntoCpus(AEKey what, long amount, Actionable type, CallbackInfoReturnable<Long> cir, @Local(ordinal=1) long inserted) {
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            for (AdvCraftingCPU cpu : cluster.getActiveCPUs()) {
                inserted += cpu.craftingLogic.insert(what, amount - inserted, type);
            }
        }
        cir.setReturnValue((Object)inserted);
    }

    @Inject(method={"submitJob"}, at={@At(value="INVOKE_ASSIGN", target="appeng/me/service/CraftingService.findSuitableCraftingCPU (Lappeng/api/networking/crafting/ICraftingPlan;ZLappeng/api/networking/security/IActionSource;Lorg/apache/commons/lang3/mutable/MutableObject;)Lappeng/me/cluster/implementations/CraftingCPUCluster;")}, cancellable=true)
    private void onSubmitJob(ICraftingPlan job, ICraftingRequester requestingMachine, ICraftingCPU target, boolean prioritizePower, IActionSource src, CallbackInfoReturnable<ICraftingSubmitResult> cir, @Local CraftingCPUCluster cpuCluster, @Local MutableObject<UnsuitableCpus> unsuitableCpusResult) {
        if (target instanceof AdvCraftingCPU) {
            AdvCraftingCPU advCpu = (AdvCraftingCPU)target;
            cir.setReturnValue((Object)advCpu.craftingLogic.trySubmitJob(this.grid, job, src, requestingMachine));
        } else {
            AdvCraftingCPUCluster advCluster = this.advancedAE$findSuitableAdvCraftingCPU(job, src, unsuitableCpusResult);
            if (advCluster != null) {
                this.updateList = true;
                cir.setReturnValue((Object)advCluster.submitJob(this.grid, job, src, requestingMachine));
            } else if (cpuCluster == null) {
                UnsuitableCpus unsuitableCpus = (UnsuitableCpus)unsuitableCpusResult.getValue();
                if (unsuitableCpus == null) {
                    cir.setReturnValue((Object)CraftingSubmitResult.NO_CPU_FOUND);
                } else {
                    cir.setReturnValue((Object)CraftingSubmitResult.noSuitableCpu((UnsuitableCpus)unsuitableCpus));
                }
            }
        }
    }

    @Unique
    private AdvCraftingCPUCluster advancedAE$findSuitableAdvCraftingCPU(ICraftingPlan job, IActionSource src, MutableObject<UnsuitableCpus> unsuitableCpusResult) {
        ArrayList<AdvCraftingCPUCluster> validCpusClusters = new ArrayList<AdvCraftingCPUCluster>(this.advancedAE$advCraftingCPUClusters.size());
        int offline = 0;
        int tooSmall = 0;
        int excluded = 0;
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            if (!cluster.isActive()) {
                ++offline;
                continue;
            }
            if (cluster.getAvailableStorage() < job.bytes()) {
                ++tooSmall;
                continue;
            }
            if (!cluster.canBeAutoSelectedFor(src)) {
                ++excluded;
                continue;
            }
            validCpusClusters.add(cluster);
        }
        if (validCpusClusters.isEmpty()) {
            if (offline > 0 || tooSmall > 0 || excluded > 0) {
                unsuitableCpusResult.setValue((Object)new UnsuitableCpus(offline, 0, tooSmall, excluded));
            }
            return null;
        }
        validCpusClusters.sort((a, b) -> {
            boolean secondPreferred;
            boolean firstPreferred = a.isPreferredFor(src);
            if (firstPreferred != (secondPreferred = b.isPreferredFor(src))) {
                return Boolean.compare(secondPreferred, firstPreferred);
            }
            return FAST_FIRST_COMPARATOR.compare((AdvCraftingCPUCluster)a, (AdvCraftingCPUCluster)b);
        });
        return (AdvCraftingCPUCluster)validCpusClusters.getFirst();
    }

    @Inject(method={"getCpus"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetCpus(CallbackInfoReturnable<ImmutableSet<ICraftingCPU>> cir, @Local ImmutableSet.Builder<ICraftingCPU> cpus) {
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            for (AdvCraftingCPU cpu : cluster.getActiveCPUs()) {
                cpus.add((Object)cpu);
            }
            cpus.add((Object)cluster.getRemainingCapacityCPU());
        }
        cir.setReturnValue((Object)cpus.build());
    }

    @Inject(method={"getRequestedAmount"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetRequestedAmount(AEKey what, CallbackInfoReturnable<Long> cir, @Local long requested) {
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            for (AdvCraftingCPU cpu : cluster.getActiveCPUs()) {
                requested += cpu.craftingLogic.getWaitingFor(what);
            }
        }
        cir.setReturnValue((Object)requested);
    }

    @Inject(method={"hasCpu"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHasCpu(ICraftingCPU cpu, CallbackInfoReturnable<Boolean> cir) {
        for (AdvCraftingCPUCluster cluster : this.advancedAE$advCraftingCPUClusters) {
            for (AdvCraftingCPU activeCpu : cluster.getActiveCPUs()) {
                if (activeCpu != cpu) continue;
                cir.setReturnValue((Object)true);
            }
        }
    }
}

