/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import appeng.api.crafting.EncodedPatternDecoder;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.InvalidPatternTooltipStrategy;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.EncodedPatternItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EncodedPatternItem.class}, remap=false)
public class MixinEncodedPatternItem<T extends IPatternDetails> {
    @Final
    @Shadow
    private EncodedPatternDecoder<T> decoder;
    @Final
    @Shadow
    @Nullable
    private InvalidPatternTooltipStrategy invalidPatternTooltip;

    @Shadow
    protected static Component getTooltipEntryLine(GenericStack stack) {
        return Component.empty();
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flags, CallbackInfo ci) {
        PatternDetailsTooltip tooltip;
        Level clientLevel;
        AEItemKey what = AEItemKey.of((ItemStack)stack);
        if (what == null) {
            ci.cancel();
        }
        if ((clientLevel = AppEng.instance().getClientLevel()) == null) {
            ci.cancel();
        }
        try {
            IPatternDetails details = Objects.requireNonNull(this.decoder.decode(what, clientLevel), "decoder returned null");
            if (!(details instanceof AdvProcessingPattern)) {
                return;
            }
            tooltip = details.getTooltip(clientLevel, flags);
        }
        catch (Exception e) {
            return;
        }
        if (tooltip != null) {
            MutableComponent label = Component.empty().append(tooltip.getOutputMethod()).append(": ").withStyle(ChatFormatting.GRAY);
            MutableComponent and = Component.literal((String)" ").append((Component)GuiText.And.text()).append(" ").withStyle(ChatFormatting.GRAY);
            MutableComponent with = GuiText.With.text().copy().append(": ").withStyle(ChatFormatting.GRAY);
            boolean first = true;
            for (GenericStack output : tooltip.getOutputs()) {
                lines.add((Component)Component.empty().append((Component)(first ? label : and)).append(MixinEncodedPatternItem.getTooltipEntryLine(output)));
                first = false;
            }
            first = true;
            for (GenericStack input : tooltip.getInputs()) {
                AdvProcessingPattern details = (AdvProcessingPattern)this.decoder.decode(what, clientLevel);
                Direction inputDirection = details.getDirectionSideForInputKey(input.what());
                String dirText = inputDirection == null ? "" : " (" + inputDirection.toString().toUpperCase().charAt(0) + ")";
                lines.add((Component)Component.empty().append((Component)(first ? with : and)).append(MixinEncodedPatternItem.getTooltipEntryLine(input)).append(dirText));
                first = false;
            }
            for (PatternDetailsTooltip.Property property : tooltip.getProperties()) {
                if (property.value() != null) {
                    lines.add((Component)Component.empty().append(property.name()).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append(property.value()));
                    continue;
                }
                lines.add((Component)Component.empty().withStyle(ChatFormatting.GRAY).append(property.name()));
            }
        }
        ci.cancel();
    }
}

