/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.quantumcomputer;

import appeng.api.config.CpuSelectionMode;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.stacks.GenericStack;
import appeng.menu.guisync.GuiSync;
import appeng.menu.guisync.PacketWritable;
import appeng.menu.me.crafting.CraftingCPUMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPU;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class QuantumComputerMenu
extends CraftingCPUMenu {
    private static final String ACTION_SELECT_CPU = "selectCpu";
    private WeakHashMap<ICraftingCPU, Integer> cpuSerialMap = new WeakHashMap();
    private int nextCpuSerial = 1;
    private List<AdvCraftingCPU> lastCpuSet = List.of();
    private int lastUpdate = 0;
    @GuiSync(value=8)
    public CraftingCpuList cpuList = EMPTY_CPU_LIST;
    @Nullable
    private ICraftingCPU selectedCpu = null;
    @GuiSync(value=9)
    private int selectedCpuSerial = -1;
    @GuiSync(value=10)
    public CpuSelectionMode selectionMode = CpuSelectionMode.ANY;
    private final AdvCraftingBlockEntity host;
    private static final CraftingCpuList EMPTY_CPU_LIST = new CraftingCpuList(Collections.emptyList());
    private static final Comparator<CraftingCpuListEntry> CPU_COMPARATOR = Comparator.comparing(e -> e.name() == null).thenComparing(e -> e.name() != null ? e.name().getString() : "").thenComparingInt(CraftingCpuListEntry::serial);

    public QuantumComputerMenu(int id, Inventory ip, AdvCraftingBlockEntity te) {
        this(AAEMenus.QUANTUM_COMPUTER, id, ip, te);
    }

    public QuantumComputerMenu(MenuType<?> menuType, int id, Inventory ip, AdvCraftingBlockEntity te) {
        super(menuType, id, ip, (Object)te);
        this.cpuList = EMPTY_CPU_LIST;
        this.host = te;
        if (te.getCluster() != null) {
            this.selectionMode = te.getCluster().getSelectionMode();
        }
        this.registerClientAction(ACTION_SELECT_CPU, Integer.class, this::selectCpu);
    }

    protected void setCPU(ICraftingCPU c) {
        super.setCPU(c);
        this.selectedCpuSerial = this.getOrAssignCpuSerial(c);
    }

    public void broadcastChanges() {
        if (this.host.getGridNode() == null) {
            super.broadcastChanges();
            return;
        }
        if (this.isServerSide() && this.host.getCluster() != null) {
            List<AdvCraftingCPU> newCpuSet = this.host.getCluster().getActiveCPUs();
            newCpuSet.add(this.host.getCluster().getRemainingCapacityCPU());
            if (!this.lastCpuSet.equals(newCpuSet) || ++this.lastUpdate >= 20) {
                this.lastCpuSet = newCpuSet;
                this.cpuList = this.createCpuList();
            }
        } else {
            this.lastUpdate = 20;
            if (!this.lastCpuSet.isEmpty()) {
                this.cpuList = EMPTY_CPU_LIST;
                this.lastCpuSet = List.of();
            }
        }
        if (this.selectedCpuSerial != -1 && this.cpuList.cpus().stream().noneMatch(c -> c.serial() == this.selectedCpuSerial)) {
            this.selectCpu(-1);
        }
        if (this.selectedCpuSerial == -1) {
            for (CraftingCpuListEntry cpu : this.cpuList.cpus()) {
                if (cpu.currentJob() == null) continue;
                this.selectCpu(cpu.serial());
                break;
            }
            if (this.selectedCpuSerial == -1 && !this.cpuList.cpus().isEmpty()) {
                this.selectCpu(this.cpuList.cpus().get(0).serial());
            }
        }
        if (this.host.getCluster() != null) {
            this.selectionMode = this.host.getCluster().getSelectionMode();
        }
        super.broadcastChanges();
    }

    private CraftingCpuList createCpuList() {
        ArrayList<CraftingCpuListEntry> entries = new ArrayList<CraftingCpuListEntry>(this.lastCpuSet.size());
        for (AdvCraftingCPU cpu : this.lastCpuSet) {
            int serial = this.getOrAssignCpuSerial(cpu);
            CraftingJobStatus status = cpu.getJobStatus();
            entries.add(new CraftingCpuListEntry(serial, cpu.getAvailableStorage(), cpu.getCoProcessors(), cpu.getName(), cpu.getSelectionMode(), status != null ? status.crafting() : null, status != null ? status.totalItems() : 0L, status != null ? status.progress() : 0L, status != null ? status.elapsedTimeNanos() : 0L));
        }
        entries.sort(CPU_COMPARATOR);
        return new CraftingCpuList(entries);
    }

    private int getOrAssignCpuSerial(ICraftingCPU cpu) {
        if (this.cpuSerialMap == null) {
            this.cpuSerialMap = new WeakHashMap();
        }
        return this.cpuSerialMap.computeIfAbsent(cpu, ignored -> this.nextCpuSerial++);
    }

    public boolean allowConfiguration() {
        return false;
    }

    public void selectCpu(int serial) {
        if (this.isClientSide()) {
            this.selectedCpuSerial = serial;
            this.sendClientAction(ACTION_SELECT_CPU, serial);
        } else {
            AdvCraftingCPU newSelectedCpu = null;
            if (serial != -1) {
                for (AdvCraftingCPU cpu : this.lastCpuSet) {
                    if (this.cpuSerialMap.getOrDefault(cpu, -1) != serial) continue;
                    newSelectedCpu = cpu;
                    break;
                }
            }
            if (newSelectedCpu != this.selectedCpu) {
                this.setCPU(newSelectedCpu);
            }
        }
    }

    public int getSelectedCpuSerial() {
        return this.selectedCpuSerial;
    }

    public CpuSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public record CraftingCpuList(List<CraftingCpuListEntry> cpus) implements PacketWritable
    {
        public CraftingCpuList(RegistryFriendlyByteBuf data) {
            this(CraftingCpuList.readFromPacket(data));
        }

        private static List<CraftingCpuListEntry> readFromPacket(RegistryFriendlyByteBuf data) {
            int count = data.readInt();
            ArrayList<CraftingCpuListEntry> result = new ArrayList<CraftingCpuListEntry>(count);
            for (int i = 0; i < count; ++i) {
                result.add(CraftingCpuListEntry.readFromPacket(data));
            }
            return result;
        }

        public void writeToPacket(RegistryFriendlyByteBuf data) {
            data.writeInt(this.cpus.size());
            for (CraftingCpuListEntry entry : this.cpus) {
                entry.writeToPacket(data);
            }
        }
    }

    public record CraftingCpuListEntry(int serial, long storage, int coProcessors, Component name, CpuSelectionMode mode, GenericStack currentJob, long totalItems, long progress, long elapsedTimeNanos) {
        public static CraftingCpuListEntry readFromPacket(RegistryFriendlyByteBuf data) {
            return new CraftingCpuListEntry(data.readInt(), data.readLong(), data.readInt(), data.readBoolean() ? (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)data) : null, (CpuSelectionMode)data.readEnum(CpuSelectionMode.class), GenericStack.readBuffer((RegistryFriendlyByteBuf)data), data.readVarLong(), data.readVarLong(), data.readVarLong());
        }

        public void writeToPacket(RegistryFriendlyByteBuf data) {
            data.writeInt(this.serial);
            data.writeLong(this.storage);
            data.writeInt(this.coProcessors);
            data.writeBoolean(this.name != null);
            if (this.name != null) {
                ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)data, (Object)this.name);
            }
            data.writeEnum((Enum)this.mode);
            GenericStack.writeBuffer((GenericStack)this.currentJob, (RegistryFriendlyByteBuf)data);
            data.writeVarLong(this.totalItems);
            data.writeVarLong(this.progress);
            data.writeVarLong(this.elapsedTimeNanos);
        }
    }
}

