/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.quantumcomputer;

import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.pedroksl.advanced_ae.gui.quantumcomputer.InfoBar;
import net.pedroksl.advanced_ae.gui.quantumcomputer.QuantumComputerMenu;
import org.jetbrains.annotations.Nullable;

public class AdvCpuSelectionList
implements ICompositeWidget {
    private static final int ROWS = 6;
    private final Blitter background;
    private final Blitter buttonBg;
    private final Blitter buttonBgSelected;
    private final QuantumComputerMenu menu;
    private final Color textColor;
    private final int selectedColor;
    private final Scrollbar scrollbar;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);

    public AdvCpuSelectionList(QuantumComputerMenu menu, Scrollbar scrollbar, ScreenStyle style) {
        this.menu = menu;
        this.scrollbar = scrollbar;
        this.background = style.getImage("cpuList");
        this.buttonBg = style.getImage("cpuListButton");
        this.buttonBgSelected = style.getImage("cpuListButtonSelected");
        this.textColor = style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        this.selectedColor = style.getColor(PaletteColor.SELECTION_COLOR).toARGB();
        this.scrollbar.setCaptureMouseWheel(false);
    }

    public void setPosition(Point position) {
        this.bounds = new Rect2i(position.getX(), position.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public void setSize(int width, int height) {
        this.bounds = new Rect2i(this.bounds.getX(), this.bounds.getY(), width, height);
    }

    public Rect2i getBounds() {
        return this.bounds;
    }

    public boolean onMouseWheel(Point mousePos, double delta) {
        this.scrollbar.onMouseWheel(mousePos, delta);
        return true;
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        QuantumComputerMenu.CraftingCpuListEntry cpu = this.hitTestCpu(new Point(mouseX, mouseY));
        if (cpu != null) {
            GenericStack currentJob;
            MutableComponent modeText;
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            tooltipLines.add(this.getCpuName(cpu));
            int coProcessors = cpu.coProcessors();
            if (coProcessors == 1) {
                tooltipLines.add(ButtonToolTips.CpuStatusCoProcessor.text(new Object[]{Tooltips.ofNumber((long)coProcessors)}).withStyle(ChatFormatting.GRAY));
            } else if (coProcessors > 1) {
                tooltipLines.add(ButtonToolTips.CpuStatusCoProcessors.text(new Object[]{Tooltips.ofNumber((long)coProcessors)}).withStyle(ChatFormatting.GRAY));
            }
            tooltipLines.add(ButtonToolTips.CpuStatusStorage.text(new Object[]{Tooltips.ofBytes((long)cpu.storage())}).withStyle(ChatFormatting.GRAY));
            switch (cpu.mode()) {
                case PLAYER_ONLY: {
                    MutableComponent mutableComponent = ButtonToolTips.CpuSelectionModePlayersOnly.text();
                    break;
                }
                case MACHINE_ONLY: {
                    MutableComponent mutableComponent = ButtonToolTips.CpuSelectionModeAutomationOnly.text();
                    break;
                }
                default: {
                    MutableComponent mutableComponent = modeText = null;
                }
            }
            if (modeText != null) {
                tooltipLines.add(modeText);
            }
            if ((currentJob = cpu.currentJob()) != null) {
                tooltipLines.add(ButtonToolTips.CpuStatusCrafting.text(new Object[]{Tooltips.ofAmount((GenericStack)currentJob)}).append(" ").append(currentJob.what().getDisplayName()));
                tooltipLines.add(ButtonToolTips.CpuStatusCraftedIn.text(new Object[]{Tooltips.ofNumber((long)cpu.progress()), Tooltips.ofDuration((long)cpu.elapsedTimeNanos(), (TimeUnit)TimeUnit.NANOSECONDS)}));
            }
            return new Tooltip(tooltipLines);
        }
        return null;
    }

    public boolean onMouseUp(Point mousePos, int button) {
        QuantumComputerMenu.CraftingCpuListEntry cpu = this.hitTestCpu(mousePos);
        if (cpu != null) {
            this.menu.selectCpu(cpu.serial());
            return true;
        }
        return false;
    }

    @Nullable
    private QuantumComputerMenu.CraftingCpuListEntry hitTestCpu(Point mousePos) {
        int relX = mousePos.getX() - this.bounds.getX();
        int relY = mousePos.getY() - this.bounds.getY();
        if ((relX -= 8) < 0 || relX >= this.buttonBg.getSrcWidth()) {
            return null;
        }
        int buttonIdx = this.scrollbar.getCurrentScroll() + (relY -= 19) / (this.buttonBg.getSrcHeight() + 1);
        if (relY % (this.buttonBg.getSrcHeight() + 1) == this.buttonBg.getSrcHeight()) {
            return null;
        }
        if (relY < 0 || buttonIdx >= this.menu.cpuList.cpus().size()) {
            return null;
        }
        List<QuantumComputerMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus();
        if (buttonIdx >= 0 && buttonIdx < cpus.size()) {
            return cpus.get(buttonIdx);
        }
        return null;
    }

    public void updateBeforeRender() {
        int hiddenRows = Math.max(0, this.menu.cpuList.cpus().size() - 6);
        this.scrollbar.setRange(0, hiddenRows, 2);
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int x = bounds.getX() + this.bounds.getX();
        int y = bounds.getY() + this.bounds.getY();
        this.background.dest(x, y, this.bounds.getWidth(), this.bounds.getHeight()).blit(guiGraphics);
        x += 8;
        y += 19;
        PoseStack pose = guiGraphics.pose();
        Font font = Minecraft.getInstance().font;
        List<QuantumComputerMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus().subList(Mth.clamp((int)this.scrollbar.getCurrentScroll(), (int)0, (int)this.menu.cpuList.cpus().size()), Mth.clamp((int)(this.scrollbar.getCurrentScroll() + 6), (int)0, (int)this.menu.cpuList.cpus().size()));
        for (QuantumComputerMenu.CraftingCpuListEntry cpu : cpus) {
            if (cpu.serial() == this.menu.getSelectedCpuSerial()) {
                this.buttonBgSelected.dest(x, y).blit(guiGraphics);
            } else {
                this.buttonBg.dest(x, y).blit(guiGraphics);
            }
            Component name = this.getCpuName(cpu);
            pose.pushPose();
            pose.translate((float)(x + 3), (float)(y + 2), 0.0f);
            pose.scale(0.666f, 0.666f, 1.0f);
            guiGraphics.drawString(font, name, 0, 0, this.textColor.toARGB(), false);
            pose.popPose();
            InfoBar infoBar = new InfoBar();
            GenericStack currentJob = cpu.currentJob();
            if (currentJob != null) {
                infoBar.add(Icon.S_CRAFT, 1.0f, x + 2, y + 9);
                String craftAmt = currentJob.what().formatAmount(currentJob.amount(), AmountFormat.SLOT);
                infoBar.add(craftAmt, this.textColor.toARGB(), 0.666f, x + 14, y + 13);
                infoBar.add(currentJob.what(), 0.666f, x + 55, y + 9);
                int progress = (int)(cpu.progress() * (long)(this.buttonBg.getSrcWidth() - 1) / Math.max(1L, cpu.totalItems()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(1.0f, -1.0f, 0.0f);
                guiGraphics.fill(x, y + this.buttonBg.getSrcHeight() - 2, x + progress, y + this.buttonBg.getSrcHeight() - 1, this.menu.getSelectedCpuSerial() == cpu.serial() ? -8541742 : this.selectedColor);
                guiGraphics.pose().popPose();
            } else {
                infoBar.add(Icon.S_STORAGE, 1.0f, x + 32, y + 9);
                String storageAmount = this.formatStorage(cpu);
                infoBar.add(storageAmount, this.textColor.toARGB(), 0.666f, x + 44, y + 13);
                if (cpu.coProcessors() > 0) {
                    infoBar.add(Icon.S_PROCESSOR, 1.0f, x + 2, y + 9);
                    String coProcessorCount = String.valueOf(cpu.coProcessors());
                    infoBar.add(coProcessorCount, this.textColor.toARGB(), 0.666f, x + 14, y + 13);
                }
                switch (cpu.mode()) {
                    case PLAYER_ONLY: {
                        infoBar.add(Icon.S_TERMINAL, 1.0f, x + 55, y + 9);
                        break;
                    }
                    case MACHINE_ONLY: {
                        infoBar.add(Icon.S_MACHINE, 1.0f, x + 55, y + 9);
                    }
                }
            }
            infoBar.render(guiGraphics, x + 2, y + this.buttonBg.getSrcHeight() - 12);
            y += this.buttonBg.getSrcHeight() + 1;
        }
    }

    private String formatStorage(QuantumComputerMenu.CraftingCpuListEntry cpu) {
        long storage = cpu.storage();
        int unit = -1;
        while (storage > 1024L) {
            storage /= 1024L;
            ++unit;
        }
        return storage + (switch (unit) {
            case 0 -> "k";
            case 1 -> "M";
            case 2 -> "G";
            default -> "T";
        });
    }

    private Component getCpuName(QuantumComputerMenu.CraftingCpuListEntry cpu) {
        return cpu.name() != null ? cpu.name() : GuiText.CPUs.text().append(String.format(" #%d", cpu.serial()));
    }
}

