/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuHostLocator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.advanced_ae.gui.SetAmountMenu;

public class StockExportBusMenu
extends UpgradeableMenu<StockExportBusPart> {
    private static final String OPEN_AMOUNT_MENU = "open_amount_menu";

    public StockExportBusMenu(int id, Inventory ip, StockExportBusPart host) {
        this(AAEMenus.STOCK_EXPORT_BUS, id, ip, host);
    }

    public StockExportBusMenu(MenuType<? extends StockExportBusMenu> menuType, int id, Inventory ip, StockExportBusPart host) {
        super(menuType, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(OPEN_AMOUNT_MENU, Integer.class, this::openAmountMenu);
    }

    protected void setupConfig() {
        this.addExpandableConfigSlots((GenericStackInv)((StockExportBusPart)this.getHost()).getConfig(), 2, 9, 5);
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.CAPACITY_CARD);
        return upgrades > idx;
    }

    public boolean isConfigSlot(Slot slot) {
        return this.getSlots(SlotSemantics.CONFIG).contains(slot);
    }

    public void openAmountMenu(int slotIndex) {
        MenuHostLocator locator;
        if (this.isClientSide()) {
            this.sendClientAction(OPEN_AMOUNT_MENU, slotIndex);
            return;
        }
        Slot slot = this.getSlot(slotIndex);
        GenericStack currentStack = GenericStack.fromItemStack((ItemStack)slot.getItem());
        if (currentStack != null && (locator = this.getLocator()) != null && this.isServerSide()) {
            SetAmountMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), currentStack, newStack -> this.setFilter(slot.index, GenericStack.wrapInItemStack((GenericStack)newStack)));
        }
    }
}

