/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.storage.ISubMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuHostLocator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class QuantumArmorNumInputConfigMenu
extends AEBaseMenu
implements ISubMenu {
    private final ISubMenuHost host;
    @GuiSync(value=7)
    public UpgradeType type;
    @GuiSync(value=9)
    public int currentValue;
    public int slotIndex;
    private static final String SET_CURRENT_VALUE = "set_current_value";

    public QuantumArmorNumInputConfigMenu(int id, Inventory playerInventory, ISubMenuHost host) {
        super(AAEMenus.QUANTUM_ARMOR_NUM_INPUT, id, playerInventory, (Object)host);
        this.host = host;
        this.registerClientAction(SET_CURRENT_VALUE, Integer.class, this::setCurrentValue);
    }

    public ISubMenuHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, int slotIndex, UpgradeType type, int currentValue) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_NUM_INPUT, (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof QuantumArmorNumInputConfigMenu) {
            QuantumArmorNumInputConfigMenu cca = (QuantumArmorNumInputConfigMenu)abstractContainerMenu;
            cca.setUpgradeType(type);
            cca.setSlotIndex(slotIndex);
            cca.setCurrentValue(currentValue);
            cca.broadcastChanges();
        }
    }

    public void setSlotIndex(int index) {
        this.slotIndex = index;
    }

    public void setUpgradeType(UpgradeType type) {
        this.type = type;
    }

    public void setCurrentValue(int value) {
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(SET_CURRENT_VALUE, value);
            return;
        }
        this.currentValue = value;
        ItemStack stack = this.getPlayer().getInventory().getItem(this.slotIndex);
        Item item2 = stack.getItem();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.type) && item.hasUpgrade(stack, this.type)) {
            stack.set(AAEComponents.UPGRADE_VALUE.get((Object)this.type), (Object)value);
        }
    }
}

