/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.upgrades;

import appeng.core.definitions.ItemDefinition;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeCards;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeSettings;

public enum UpgradeType {
    EMPTY("Empty", null, SettingType.NONE, 0, ApplicationType.PASSIVE, AAEItems.QUANTUM_UPGRADE_BASE),
    WALK_SPEED("Walk Speed", UpgradeCards::walkSpeed, SettingType.NUM_INPUT, 10, ApplicationType.PASSIVE, AAEItems.WALK_SPEED_CARD),
    SPRINT_SPEED("Sprint Speed", UpgradeCards::sprintSpeed, SettingType.NUM_INPUT, 10, ApplicationType.PASSIVE, AAEItems.SPRINT_SPEED_CARD),
    STEP_ASSIST("Step Assist", null, SettingType.NUM_INPUT, 5, ApplicationType.PASSIVE_USE, AAEItems.STEP_ASSIST_CARD),
    JUMP_HEIGHT("Jump Height", UpgradeCards::jumpHeight, SettingType.NUM_INPUT, 10, ApplicationType.PASSIVE_USE, AAEItems.JUMP_HEIGHT_CARD),
    LAVA_IMMUNITY("Lava Immunity", null, SettingType.NONE, 10, ApplicationType.PASSIVE_USE, AAEItems.LAVA_IMMUNITY_CARD),
    FLIGHT("Flight", null, SettingType.NUM_INPUT, 10, ApplicationType.PASSIVE_USE, AAEItems.FLIGHT_CARD),
    WATER_BREATHING("Water Breathing", null, SettingType.NONE, 10, ApplicationType.PASSIVE_USE, AAEItems.WATER_BREATHING_CARD),
    AUTO_FEED("Auto Feed", UpgradeCards::autoFeed, SettingType.FILTER, 5, ApplicationType.PASSIVE, AAEItems.AUTO_FEED_CARD),
    AUTO_STOCK("Auto Stock", UpgradeCards::autoStock, SettingType.FILTER, 5, ApplicationType.PASSIVE, AAEItems.AUTO_STOCK_CARD),
    MAGNET("Magnet", UpgradeCards::magnet, SettingType.NUM_AND_FILTER, 5, ApplicationType.PASSIVE, AAEItems.MAGNET_CARD, ExtraSettings.BLACKLIST),
    HP_BUFFER("HP Buffer", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.HP_BUFFER_CARD),
    EVASION("Evasion", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.EVASION_CARD),
    REGENERATION("Regeneration", UpgradeCards::regeneration, SettingType.NONE, 10, ApplicationType.PASSIVE, AAEItems.REGENERATION_CARD),
    STRENGTH("Strength", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.STRENGTH_CARD),
    ATTACK_SPEED("Attack Speed", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.ATTACK_SPEED_CARD),
    LUCK("Luck Boost", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.LUCK_CARD),
    REACH("Reach Boost", null, SettingType.NUM_INPUT, 10, ApplicationType.BUFF, AAEItems.REACH_CARD),
    SWIM_SPEED("Swim Speed", UpgradeCards::swimSpeed, SettingType.NUM_INPUT, 5, ApplicationType.PASSIVE, AAEItems.SWIM_SPEED_CARD),
    NIGHT_VISION("Night Vision", null, SettingType.NONE, 10, ApplicationType.BUFF, AAEItems.NIGHT_VISION_CARD),
    FLIGHT_DRIFT("No Flight Drift", null, SettingType.NUM_INPUT, 10, ApplicationType.BUFF, AAEItems.FLIGHT_DRIFT_CARD),
    CHARGING("ME Recharging", UpgradeCards::recharging, SettingType.NONE, 0, ApplicationType.PASSIVE, AAEItems.RECHARGING_CARD),
    WORKBENCH("Portable Workbench", null, SettingType.NONE, 0, ApplicationType.PASSIVE_USE, AAEItems.WORKBENCH_CARD),
    PICK_CRAFT("Pick-Craft", null, SettingType.NONE, 1000, ApplicationType.PASSIVE_USE, AAEItems.PICK_CRAFT_CARD);

    public final String name;
    public final Ability ability;
    private final SettingType settingType;
    private final int cost;
    public final ApplicationType applicationType;
    private final ItemDefinition<? extends QuantumUpgradeBaseItem> item;
    private final ExtraSettings extra;

    private UpgradeType(String name, Ability ability, SettingType settingType, int cost, ApplicationType applicationType, ItemDefinition<? extends QuantumUpgradeBaseItem> item) {
        this(name, ability, settingType, cost, applicationType, item, ExtraSettings.NONE);
    }

    private UpgradeType(String name, Ability ability, SettingType settingType, int cost, ApplicationType applicationType, ItemDefinition<? extends QuantumUpgradeBaseItem> item, ExtraSettings extra) {
        this.name = name;
        this.ability = ability;
        this.settingType = settingType;
        this.cost = cost;
        this.applicationType = applicationType;
        this.item = item;
        this.extra = extra;
    }

    public ItemDefinition<? extends QuantumUpgradeBaseItem> item() {
        return this.item;
    }

    public SettingType getSettingType() {
        return this.settingType;
    }

    public int getCost() {
        return this.cost;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public UpgradeSettings getSettings() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 5, 7, 8, 9, 13, 19, 21, 22, 23 -> new UpgradeSettings(1);
            case 1 -> new UpgradeSettings(1, AAEConfig.instance().getMaxWalkSpeed(), 0.1f);
            case 2 -> new UpgradeSettings(1, AAEConfig.instance().getMaxSprintSpeed(), 0.1f);
            case 3 -> new UpgradeSettings(1, AAEConfig.instance().getMaxStepHeight());
            case 4 -> new UpgradeSettings(1, AAEConfig.instance().getMaxJumpHeight());
            case 10 -> new UpgradeSettings(3, AAEConfig.instance().getMaxMagnetRange());
            case 11 -> new UpgradeSettings(AAEConfig.instance().getmaxHpBuffer());
            case 6 -> new UpgradeSettings(1, AAEConfig.instance().getMaxFlightSpeed());
            case 12 -> new UpgradeSettings(AAEConfig.instance().getEvasionChance());
            case 14 -> new UpgradeSettings(AAEConfig.instance().getStrengthBoost());
            case 15 -> new UpgradeSettings(AAEConfig.instance().getAttackSpeedBoost());
            case 16 -> new UpgradeSettings(AAEConfig.instance().getLuckBoost());
            case 17 -> new UpgradeSettings(1, AAEConfig.instance().getMaxReachBoost());
            case 18 -> new UpgradeSettings(1, AAEConfig.instance().getMaxSwimSpeedBoost(), 0.1f);
            case 20 -> new UpgradeSettings(0, 100, 1.0f, 50);
        };
    }

    public MutableComponent getTooltip() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AAEText.UpgradeBaseTooltip.text();
            case 1 -> AAEText.WalkSpeedTooltip.text();
            case 2 -> AAEText.SprintSpeedTooltip.text();
            case 3 -> AAEText.StepAssistTooltip.text(new Object[]{AAEConfig.instance().getMaxStepHeight()});
            case 4 -> AAEText.JumpHeightTooltip.text(new Object[]{AAEConfig.instance().getMaxJumpHeight()});
            case 5 -> AAEText.LavaImmunityTooltip.text();
            case 6 -> AAEText.FlightTooltip.text();
            case 7 -> AAEText.WaterBreathingTooltip.text();
            case 8 -> AAEText.AutoFeedTooltip.text();
            case 9 -> AAEText.AutoStockTooltip.text();
            case 10 -> AAEText.MagnetTooltip.text(new Object[]{AAEConfig.instance().getMaxMagnetRange()});
            case 11 -> AAEText.HpBufferTooltip.text(new Object[]{AAEConfig.instance().getmaxHpBuffer()});
            case 12 -> AAEText.EvasionTooltip.text(new Object[]{AAEConfig.instance().getEvasionChance()});
            case 13 -> AAEText.RegenerationTooltip.text();
            case 14 -> AAEText.StrengthTooltip.text(new Object[]{AAEConfig.instance().getStrengthBoost()});
            case 15 -> AAEText.AttackSpeedTooltip.text(new Object[]{AAEConfig.instance().getAttackSpeedBoost()});
            case 16 -> AAEText.LuckTooltip.text(new Object[]{AAEConfig.instance().getLuckBoost()});
            case 17 -> AAEText.ReachTooltip.text(new Object[]{AAEConfig.instance().getMaxReachBoost()});
            case 18 -> AAEText.SwimSpeedTooltip.text();
            case 19 -> AAEText.NightVisionTooltip.text();
            case 20 -> AAEText.FlightDriftTooltip.text();
            case 21 -> AAEText.RechargingTooltip.text();
            case 22 -> AAEText.PortableWorkbenchTooltip.text();
            case 23 -> AAEText.PortableWorkbenchTooltip.text();
        };
    }

    public ExtraSettings getExtraSettings() {
        return this.extra;
    }

    public static enum ExtraSettings {
        NONE,
        BLACKLIST;

    }

    @FunctionalInterface
    public static interface Ability {
        public boolean execute(Level var1, Player var2, ItemStack var3);
    }

    public static enum SettingType {
        NONE,
        NUM_INPUT,
        FILTER,
        NUM_AND_FILTER,
        BOOL_LIST;

    }

    public static enum ApplicationType {
        PASSIVE,
        PASSIVE_USE,
        BUFF;

    }
}

