/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.ids.AEComponents;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.Tooltips;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PoweredItem
extends ArmorItem
implements IAEItemPowerStorage {
    private static final double MIN_POWER = 1.0E-4;
    private final DoubleSupplier powerCapacity;

    public PoweredItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, DoubleSupplier powerCapacity) {
        super(material, type, properties);
        this.powerCapacity = powerCapacity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        double storedEnergy = this.getAECurrentPower(stack);
        double energyCapacity = this.getAEMaxPower(stack);
        lines.add(Tooltips.energyStorageComponent((double)storedEnergy, (double)energyCapacity));
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getAECurrentPower(stack) / this.getAEMaxPower(stack) < (double)0.99f;
    }

    public int getBarWidth(ItemStack stack) {
        double filled = this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
        return Mth.clamp((int)((int)(filled * 13.0)), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    public double injectAEPower(ItemStack stack, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(stack);
        double currentStorage = this.getAECurrentPower(stack);
        double required = maxStorage - currentStorage;
        double overflow = Math.max(0.0, Math.min(amount - required, amount));
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(amount, required);
            this.setAECurrentPower(stack, currentStorage + toAdd);
        }
        return overflow;
    }

    public double extractAEPower(ItemStack stack, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(stack);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            this.setAECurrentPower(stack, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    public double getAEMaxPower(ItemStack stack) {
        return (Double)stack.getOrDefault(AEComponents.ENERGY_CAPACITY, (Object)this.powerCapacity.getAsDouble());
    }

    protected final void setAEMaxPower(ItemStack stack, double maxPower) {
        double defaultCapacity = this.powerCapacity.getAsDouble();
        if (Math.abs(maxPower - defaultCapacity) < 1.0E-4) {
            stack.remove(AEComponents.ENERGY_CAPACITY);
        } else {
            stack.set(AEComponents.ENERGY_CAPACITY, (Object)maxPower);
        }
        double currentPower = this.getAECurrentPower(stack);
        if (currentPower > maxPower) {
            this.setAECurrentPower(stack, maxPower);
        }
    }

    protected final void setAEMaxPowerMultiplier(ItemStack stack, int multiplier) {
        multiplier = Mth.clamp((int)multiplier, (int)1, (int)100);
        this.setAEMaxPower(stack, (double)multiplier * this.powerCapacity.getAsDouble());
    }

    protected final void resetAEMaxPower(ItemStack stack) {
        this.setAEMaxPower(stack, this.powerCapacity.getAsDouble());
    }

    public double getAECurrentPower(ItemStack is) {
        return (Double)is.getOrDefault(AEComponents.STORED_ENERGY, (Object)0.0);
    }

    protected final void setAECurrentPower(ItemStack stack, double power) {
        if (power < 1.0E-4) {
            stack.remove(AEComponents.STORED_ENERGY);
        } else {
            stack.set(AEComponents.STORED_ENERGY, (Object)power);
        }
    }

    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public double getChargeRate(ItemStack itemStack) {
        return 20000.0;
    }
}

