/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.items.parts.PartItem;
import appeng.parts.AEBasePart;
import appeng.parts.crafting.PatternProviderPart;
import com.glodblock.github.extendedae.common.parts.PartExPatternProvider;
import com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider;
import com.glodblock.github.extendedae.util.FCUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.pedroksl.advanced_ae.common.blocks.AdvPatternProviderBlock;
import net.pedroksl.advanced_ae.common.blocks.SmallAdvPatternProviderBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;

public class AdvPatternProviderUpgradeItem
extends Item {
    public AdvPatternProviderUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity == null) return InteractionResult.PASS;
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        Class<?> tClazz = entity.getClass();
        if (tClazz == PatternProviderBlockEntity.class || tClazz == TileExPatternProvider.class) {
            BlockState state;
            BlockState originState = world.getBlockState(pos);
            boolean isSmall = tClazz == PatternProviderBlockEntity.class;
            BlockState blockState = state = isSmall ? ((SmallAdvPatternProviderBlock)AAEBlocks.SMALL_ADV_PATTERN_PROVIDER.block()).getStateForPlacement(ctx) : ((AdvPatternProviderBlock)AAEBlocks.ADV_PATTERN_PROVIDER.block()).getStateForPlacement(ctx);
            if (state == null) {
                return InteractionResult.PASS;
            }
            for (Map.Entry sp : originState.getValues().entrySet()) {
                Property pt = (Property)sp.getKey();
                Comparable va = (Comparable)sp.getValue();
                try {
                    if (!state.hasProperty(pt)) continue;
                    state = (BlockState)state.setValue(pt, va);
                }
                catch (Exception exception) {}
            }
            Object object = isSmall ? AAEBlockEntities.SMALL_ADV_PATTERN_PROVIDER.get() : AAEBlockEntities.ADV_PATTERN_PROVIDER.get();
            BlockEntity te = object.create(pos, state);
            FCUtil.replaceTile((Level)world, (BlockPos)pos, (BlockEntity)entity, (BlockEntity)te, (BlockState)state);
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        if (!(entity instanceof CableBusBlockEntity)) return InteractionResult.PASS;
        CableBusBlockEntity cable = (CableBusBlockEntity)entity;
        Vec3 hitVec = context.getClickLocation();
        Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
        IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
        if (!(part instanceof AEBasePart)) return InteractionResult.PASS;
        AEBasePart aEBasePart = (AEBasePart)part;
        if (part.getClass() != PatternProviderPart.class && part.getClass() != PartExPatternProvider.class) return InteractionResult.PASS;
        Direction side = aEBasePart.getSide();
        CompoundTag contents = new CompoundTag();
        boolean isSmall = part.getClass() == PatternProviderPart.class;
        PartItem partItem = isSmall ? (PartItem)AAEItems.SMALL_ADV_PATTERN_PROVIDER.get() : (PartItem)AAEItems.ADV_PATTERN_PROVIDER.get();
        part.writeToNBT(contents, (HolderLookup.Provider)world.registryAccess());
        AdvPatternProviderPart p = (AdvPatternProviderPart)cable.replacePart((IPartItem)partItem, side, context.getPlayer(), null);
        if (p != null) {
            p.readFromNBT(contents, (HolderLookup.Provider)world.registryAccess());
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)AAEText.PatternProviderUpgrade.text().withColor(0x7E7E7E));
    }
}

