/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.config.Actionable;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ILinkStatus;
import appeng.api.storage.ISubMenuHost;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.items.armors.IGridLinkedItem;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class PickCraftMenuHost<T extends QuantumArmorBase>
extends ItemMenuHost<T>
implements ISubMenuHost,
IActionHost {
    @Nullable
    private IWirelessAccessPoint currentAccessPoint;
    protected double currentDistanceFromGrid = Double.MAX_VALUE;
    protected double currentRemainingRange = Double.MIN_VALUE;
    private ILinkStatus linkStatus = ILinkStatus.ofDisconnected();

    public PickCraftMenuHost(T item, Player player, ItemMenuHostLocator locator) {
        super(item, player, locator);
        this.updateConnectedAccessPoint();
        this.updateLinkStatus();
    }

    private IGrid getLinkedGrid(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IGridLinkedItem) {
            IGridLinkedItem item2 = (IGridLinkedItem)item;
            return item2.getLinkedGrid(stack, this.getPlayer().level());
        }
        return null;
    }

    public void tick() {
        this.updateConnectedAccessPoint();
        this.consumeIdlePower(Actionable.MODULATE);
        this.updateLinkStatus();
    }

    protected void updateConnectedAccessPoint() {
        this.currentAccessPoint = null;
        this.currentDistanceFromGrid = Double.MAX_VALUE;
        this.currentRemainingRange = Double.MIN_VALUE;
        IGrid targetGrid = this.getLinkedGrid(this.getItemStack());
        if (targetGrid != null) {
            @Nullable WirelessAccessPointBlockEntity bestWap = null;
            double bestSqDistance = Double.MAX_VALUE;
            double bestSqRemainingRange = Double.MIN_VALUE;
            for (WirelessAccessPointBlockEntity wap : targetGrid.getMachines(WirelessAccessPointBlockEntity.class)) {
                AccessPointSignal signal = this.getAccessPointSignal((IWirelessAccessPoint)wap);
                if (signal.distanceSquared < bestSqDistance) {
                    bestSqDistance = signal.distanceSquared;
                    bestWap = wap;
                }
                if (!(signal.remainingRangeSquared > bestSqRemainingRange)) continue;
                bestSqRemainingRange = signal.remainingRangeSquared;
            }
            this.currentAccessPoint = bestWap;
            this.currentDistanceFromGrid = Math.sqrt(bestSqDistance);
            this.currentRemainingRange = Math.sqrt(bestSqRemainingRange);
        }
    }

    protected AccessPointSignal getAccessPointSignal(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double offX;
        double r;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() == this.getPlayer().level() && (r = (offX = (double)dc.getPos().getX() - this.getPlayer().getX()) * offX + (offY = (double)dc.getPos().getY() - this.getPlayer().getY()) * offY + (offZ = (double)dc.getPos().getZ() - this.getPlayer().getZ()) * offZ) < rangeLimit && wap.isActive()) {
            return new AccessPointSignal(r, rangeLimit - r);
        }
        return new AccessPointSignal(Double.MAX_VALUE, Double.MIN_VALUE);
    }

    protected void updateLinkStatus() {
        if (!this.consumeIdlePower(Actionable.SIMULATE)) {
            this.linkStatus = ILinkStatus.ofDisconnected((Component)GuiText.OutOfPower.text());
        } else if (this.currentAccessPoint != null) {
            this.linkStatus = ILinkStatus.ofConnected();
        } else {
            MutableObject errorHolder = new MutableObject();
            this.linkStatus = ((QuantumArmorBase)this.getItem()).getLinkedGrid(this.getItemStack(), this.getPlayer().level(), arg_0 -> ((MutableObject)errorHolder).setValue(arg_0)) == null ? ILinkStatus.ofDisconnected((Component)((Component)errorHolder.getValue())) : ILinkStatus.ofDisconnected((Component)PlayerMessages.OutOfRange.text());
        }
    }

    @Nullable
    public IGridNode getActionableNode() {
        if (this.currentAccessPoint != null) {
            return this.currentAccessPoint.getActionableNode();
        }
        return null;
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        ((AEBaseMenu)this.getPlayer().containerMenu).setValidMenu(false);
    }

    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    public record AccessPointSignal(double distanceSquared, double remainingRangeSquared) {
    }
}

