/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.crafting.CraftingCubeModelData;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.util.NullConfigManager;
import appeng.util.Platform;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.pedroksl.advanced_ae.common.blocks.AAEAbstractCraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCalculator;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;

public class AdvCraftingBlockEntity
extends AENetworkedBlockEntity
implements IAEMultiBlock<AdvCraftingCPUCluster>,
IPowerChannelState,
IConfigurableObject {
    private final AdvCraftingCPUCalculator calc = new AdvCraftingCPUCalculator(this);
    private CompoundTag previousState = null;
    private boolean isCoreBlock = false;
    private AdvCraftingCPUCluster cluster;

    public AdvCraftingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL}).addService(IGridMultiblock.class, (IGridNodeService)((IGridMultiblock)this::getMultiblockNodes));
    }

    protected Item getItemFromBlockEntity() {
        if (this.level == null) {
            return Items.AIR;
        }
        return this.getUnitBlock().type.getItemFromType();
    }

    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public AAEAbstractCraftingUnitBlock<?> getUnitBlock() {
        if (this.level == null || this.notLoaded() || this.isRemoved()) {
            return (AAEAbstractCraftingUnitBlock)AAEBlocks.QUANTUM_UNIT.block();
        }
        Block block = this.level.getBlockState(this.worldPosition).getBlock();
        return block instanceof AAEAbstractCraftingUnitBlock ? (AAEAbstractCraftingUnitBlock)block : (AAEAbstractCraftingUnitBlock)AAEBlocks.QUANTUM_UNIT.block();
    }

    public long getStorageBytes() {
        return this.getUnitBlock().type.getStorageBytes();
    }

    public int getStorageMultiplier() {
        return ((AAECraftingUnitType)this.getUnitBlock().type).getStorageMultiplier();
    }

    public int getAcceleratorThreads() {
        return this.getUnitBlock().type.getAcceleratorThreads();
    }

    public int getAccelerationMultiplier() {
        return ((AAECraftingUnitType)this.getUnitBlock().type).getAccelerationMultiplier();
    }

    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity());
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.worldPosition);
        }
    }

    public void updateMultiBlock(BlockPos changedPos) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.worldPosition, changedPos);
        }
    }

    public void updateStatus(AdvCraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        if (this.level == null || this.notLoaded() || this.isRemoved()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        BlockState current = this.level.getBlockState(this.worldPosition);
        if (current.getBlock() instanceof AAEAbstractCraftingUnitBlock) {
            int lightLevel = this.getUnitBlock().type == AAECraftingUnitType.QUANTUM_CORE ? 10 : (this.getUnitBlock().type == AAECraftingUnitType.STRUCTURE ? 5 : 0);
            lightLevel = formed && power ? lightLevel : 0;
            BlockState newState = (BlockState)((BlockState)((BlockState)current.setValue((Property)AAEAbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).setValue((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed))).setValue((Property)AAECraftingUnitBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
            if (current != newState) {
                this.level.setBlock(this.worldPosition, newState, 2);
            }
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return this.getUnitBlock().type == AAECraftingUnitType.QUANTUM_CORE ? EnumSet.of(Direction.UP, Direction.DOWN) : EnumSet.allOf(Direction.class);
        }
        return EnumSet.noneOf(Direction.class);
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.getBlockState().getValue((Property)AAEAbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putBoolean("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data, registries);
        }
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.setCoreBlock(data.getBoolean("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data, registries);
            } else {
                this.setPreviousState(data.copy());
            }
        }
    }

    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    public AdvCraftingCPUCluster getCluster() {
        return this.cluster;
    }

    public boolean isValid() {
        return true;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.cancelJobs();
            List<ListCraftingInventory> inventories = this.cluster.getInventories();
            ArrayList<BlockPos> places = new ArrayList<BlockPos>();
            for (AdvCraftingBlockEntity blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.worldPosition);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = blockEntity.worldPosition.relative(d);
                    if (!this.level.isEmptyBlock(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(String.valueOf(this.cluster) + " does not contain any kind of blocks, which were destroyed.");
            }
            for (ListCraftingInventory inv : inventories) {
                for (Object2LongMap.Entry entry : inv.list) {
                    BlockPos position = (BlockPos)Util.getRandom(places, (RandomSource)this.level.getRandom());
                    ArrayList stacks = new ArrayList();
                    ((AEKey)entry.getKey()).addDrops(entry.getLongValue(), stacks, this.level, position);
                    Platform.spawnDrops((Level)this.level, (BlockPos)position, stacks);
                }
                inv.clear();
            }
            this.cluster.destroy();
        }
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)AAEAbstractCraftingUnitBlock.POWERED);
        }
        return this.getMainNode().isActive();
    }

    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public CompoundTag getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundTag previousState) {
        this.previousState = previousState;
    }

    public ModelData getModelData() {
        return CraftingCubeModelData.create(this.getConnections());
    }

    protected EnumSet<Direction> getConnections() {
        if (this.level == null) {
            return EnumSet.noneOf(Direction.class);
        }
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!this.isConnected((BlockGetter)this.level, this.worldPosition, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(BlockGetter level, BlockPos pos, Direction side) {
        BlockPos adjacentPos = pos.relative(side);
        return level.getBlockState(adjacentPos).getBlock() instanceof AAEAbstractCraftingUnitBlock;
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.requestModelDataUpdate();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator((Object[])new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), IGridConnectedBlockEntity::getGridNode);
    }

    public IConfigManager getConfigManager() {
        AdvCraftingCPUCluster cluster = this.getCluster();
        if (cluster != null) {
            return this.getCluster().getConfigManager();
        }
        return NullConfigManager.INSTANCE;
    }
}

