/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.core.definitions.ItemDefinition;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderCapacityUpgradeItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderUpgradeItem;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.SmallAdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.advanced_ae.common.parts.ThroughputMonitorPart;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;

public class AAEItems {
    public static final DeferredRegister.Items DR = DeferredRegister.createItems((String)"advanced_ae");
    private static final List<ItemDefinition<?>> ITEMS = new ArrayList();
    public static final ItemDefinition<PartItem<AdvPatternProviderPart>> ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Extended Pattern Provider", "adv_pattern_provider_part", AdvPatternProviderPart.class, AdvPatternProviderPart::new);
    public static final ItemDefinition<PartItem<SmallAdvPatternProviderPart>> SMALL_ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Pattern Provider", "small_adv_pattern_provider_part", SmallAdvPatternProviderPart.class, SmallAdvPatternProviderPart::new);
    public static final ItemDefinition<PartItem<StockExportBusPart>> STOCK_EXPORT_BUS = AAEItems.part("Stock Export Bus", "stock_export_bus_part", StockExportBusPart.class, StockExportBusPart::new);
    public static final ItemDefinition<PartItem<ThroughputMonitorPart>> THROUGHPUT_MONITOR = AAEItems.part("ME Throughput Monitor", "throughput_monitor", ThroughputMonitorPart.class, ThroughputMonitorPart::new);
    public static final ItemDefinition<Item> ADV_PROCESSING_PATTERN = AAEItems.item("Advanced Processing Pattern", "adv_processing_pattern", p -> PatternDetailsHelper.encodedPatternItemBuilder(AdvProcessingPattern::new).invalidPatternTooltip(AdvProcessingPattern::getInvalidPatternTooltip).build());
    public static final ItemDefinition<Item> ADV_PATTERN_PROVIDER_UPGRADE = AAEItems.item("Advanced Pattern Provider Upgrade", "adv_pattern_provider_upgrade", AdvPatternProviderUpgradeItem::new);
    public static final ItemDefinition<Item> ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE = AAEItems.item("Advanced Pattern Provider Capacity Upgrade", "adv_pattern_provider_capacity_upgrade", AdvPatternProviderCapacityUpgradeItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_INFUSED_DUST = AAEItems.item("Quantum Infused Dust", "quantum_infused_dust", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_ALLOY = AAEItems.item("Quantum Alloy", "quantum_alloy", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_ALLOY_PLATE = AAEItems.item("Quantum Alloy Plate", "quantum_alloy_plate", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> SHATTERED_SINGULARITY = AAEItems.item("Shattered Singularity", "shattered_singularity", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRESS = AAEItems.item("Inscriber Quantum Press", "quantum_processor_press", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRINT = AAEItems.item("Printed Quantum Circuit", "printed_quantum_processor", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_PROCESSOR = AAEItems.item("Quantum Processor", "quantum_processor", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> QUANTUM_STORAGE_COMPONENT = AAEItems.item("Quantum Storage Component", "quantum_storage_component", MaterialItem::new);
    public static final ItemDefinition<AdvPatternEncoderItem> ADV_PATTERN_ENCODER = AAEItems.item("Advanced Pattern Encoder", "adv_pattern_encoder", AdvPatternEncoderItem::new);
    public static final ItemDefinition<Item> MONITOR_CONFIGURATOR = AAEItems.item("Throughput Monitor Configurator", "throughput_monitor_configurator", Item::new);
    public static final ItemDefinition<QuantumHelmet> QUANTUM_HELMET = AAEItems.item("Quantum Helmet", "quantum_helmet", QuantumHelmet::new);
    public static final ItemDefinition<QuantumChestplate> QUANTUM_CHESTPLATE = AAEItems.item("Quantum Chestplate", "quantum_chestplate", QuantumChestplate::new);
    public static final ItemDefinition<QuantumLeggings> QUANTUM_LEGGINGS = AAEItems.item("Quantum Leggings", "quantum_leggings", QuantumLeggings::new);
    public static final ItemDefinition<QuantumBoots> QUANTUM_BOOTS = AAEItems.item("Quantum Boots", "quantum_boots", QuantumBoots::new);
    public static final ItemDefinition<QuantumUpgradeBaseItem> QUANTUM_UPGRADE_BASE = AAEItems.item("Quantum Upgrade Base Card", "quantum_upgrade_base", QuantumUpgradeBaseItem::new);
    public static final ItemDefinition<QuantumUpgradeBaseItem> WALK_SPEED_CARD = AAEItems.item("Walk Speed Card", "walk_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WALK_SPEED, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> SPRINT_SPEED_CARD = AAEItems.item("Sprint Speed Card", "sprint_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.SPRINT_SPEED, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> STEP_ASSIST_CARD = AAEItems.item("Step Assist Card", "step_assist_card", p -> new QuantumUpgradeBaseItem(UpgradeType.STEP_ASSIST, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> JUMP_HEIGHT_CARD = AAEItems.item("Jump Height Card", "jump_height_card", p -> new QuantumUpgradeBaseItem(UpgradeType.JUMP_HEIGHT, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> LAVA_IMMUNITY_CARD = AAEItems.item("Lava Immunity Card", "lava_immunity_card", p -> new QuantumUpgradeBaseItem(UpgradeType.LAVA_IMMUNITY, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> FLIGHT_CARD = AAEItems.item("Flight Card", "flight_card", p -> new QuantumUpgradeBaseItem(UpgradeType.FLIGHT, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> WATER_BREATHING_CARD = AAEItems.item("Water Breathing Card", "water_breathing_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WATER_BREATHING, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> AUTO_FEED_CARD = AAEItems.item("Auto Feeding Card", "auto_feeding_card", p -> new QuantumUpgradeBaseItem(UpgradeType.AUTO_FEED, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> AUTO_STOCK_CARD = AAEItems.item("Auto Stock Card", "auto_stock_card", p -> new QuantumUpgradeBaseItem(UpgradeType.AUTO_STOCK, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> MAGNET_CARD = AAEItems.item("Magnet Card", "magnet_card", p -> new QuantumUpgradeBaseItem(UpgradeType.MAGNET, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> HP_BUFFER_CARD = AAEItems.item("HP Buffer Card", "hp_buffer_card", p -> new QuantumUpgradeBaseItem(UpgradeType.HP_BUFFER, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> EVASION_CARD = AAEItems.item("Evasion Card", "evasion_card", p -> new QuantumUpgradeBaseItem(UpgradeType.EVASION, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> REGENERATION_CARD = AAEItems.item("Regeneration Card", "regeneration_card", p -> new QuantumUpgradeBaseItem(UpgradeType.REGENERATION, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> STRENGTH_CARD = AAEItems.item("Strength Card", "strength_card", p -> new QuantumUpgradeBaseItem(UpgradeType.STRENGTH, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> ATTACK_SPEED_CARD = AAEItems.item("Attack Speed Card", "attack_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.ATTACK_SPEED, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> LUCK_CARD = AAEItems.item("Luck Card", "luck_card", p -> new QuantumUpgradeBaseItem(UpgradeType.LUCK, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> REACH_CARD = AAEItems.item("Reach Card", "reach_card", p -> new QuantumUpgradeBaseItem(UpgradeType.REACH, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> SWIM_SPEED_CARD = AAEItems.item("Swim Speed Card", "swim_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.SWIM_SPEED, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> NIGHT_VISION_CARD = AAEItems.item("Night Vision Card", "night_vision_card", p -> new QuantumUpgradeBaseItem(UpgradeType.NIGHT_VISION, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> FLIGHT_DRIFT_CARD = AAEItems.item("Flight Drift Card", "flight_drift_card", p -> new QuantumUpgradeBaseItem(UpgradeType.FLIGHT_DRIFT, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> RECHARGING_CARD = AAEItems.item("ME Recharging Card", "recharging_card", p -> new QuantumUpgradeBaseItem(UpgradeType.CHARGING, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> WORKBENCH_CARD = AAEItems.item("Portable Workbench Card", "portable_workbench_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WORKBENCH, (Item.Properties)p));
    public static final ItemDefinition<QuantumUpgradeBaseItem> PICK_CRAFT_CARD = AAEItems.item("Pick Craft Card", "pick_craft_card", p -> new QuantumUpgradeBaseItem(UpgradeType.PICK_CRAFT, (Item.Properties)p));

    public static List<ItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    public static List<ItemDefinition<?>> getQuantumArmor() {
        return ITEMS.stream().filter(item -> item.stack().getItem() instanceof QuantumArmorBase).toList();
    }

    public static List<ItemDefinition<?>> getQuantumCards() {
        return ITEMS.stream().filter(item -> item.stack().getItem() instanceof QuantumUpgradeBaseItem).toList();
    }

    private static <T extends Item> ItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        ItemDefinition definition = new ItemDefinition(englishName, DR.registerItem(id, factory));
        ITEMS.add(definition);
        return definition;
    }

    private static <T extends IPart> ItemDefinition<PartItem<T>> part(String englishName, String id, Class<T> partClass, Function<IPartItem<T>, T> factory) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        return AAEItems.item(englishName, id, p -> new PartItem(p, partClass, factory));
    }
}

