/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.AEBaseItem;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;

public final class AAECreativeTab {
    public static final DeferredRegister<CreativeModeTab> DR = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"advanced_ae");

    private static void populateTab(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        ArrayList<Object> itemDefs = new ArrayList<Object>();
        itemDefs.addAll(AAEItems.getItems());
        itemDefs.addAll(AAEBlocks.getBlocks().stream().map(BlockDefinition::item).toList());
        itemDefs.addAll(AAEFluids.getFluids().stream().map(FluidDefinition::bucketItemId).toList());
        for (ItemDefinition itemDefinition : itemDefs) {
            AEBaseBlockItem baseItem;
            Block block;
            Item item = itemDefinition.asItem();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)item).getBlock()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(params, output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)item;
                baseItem2.addToMainCreativeTab(params, output);
                continue;
            }
            output.accept((ItemLike)itemDefinition);
        }
    }

    static {
        DR.register("tab", () -> CreativeModeTab.builder().title((Component)AAEText.ModName.text()).icon(() -> AAEBlocks.ADV_PATTERN_PROVIDER.stack()).displayItems(AAECreativeTab::populateTab).build());
    }
}

