/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AAEConfig {
    private final ClientConfig client = new ClientConfig();
    private final CommonConfig common = new CommonConfig();
    private static AAEConfig INSTANCE;

    AAEConfig(ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.client.spec);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.common.spec);
    }

    public int getQuantumComputerMaxSize() {
        return (Integer)this.common.quantumComputerMaxSize.get();
    }

    public int getQuantumComputerAcceleratorThreads() {
        return (Integer)this.common.quantumComputerAcceleratorThreads.get();
    }

    public int getQuantumComputerMaxMultiThreaders() {
        return (Integer)this.common.quantumComputerMaxMultiThreaders.get();
    }

    public int getQuantumComputermaxDataEntanglers() {
        return (Integer)this.common.quantumComputerMaxDataEntanglers.get();
    }

    public int getQuantumComputerMultiThreaderMultiplication() {
        return (Integer)this.common.quantumComputerMultiThreaderMultiplication.get();
    }

    public int getQuantumComputerDataEntanglerMultiplication() {
        return (Integer)this.common.quantumComputerDataEntanglerMultiplication.get();
    }

    public int getMaxWalkSpeed() {
        return (Integer)this.common.maxWalkSpeed.get();
    }

    public int getMaxSprintSpeed() {
        return (Integer)this.common.maxSprintSpeed.get();
    }

    public int getMaxStepHeight() {
        return (Integer)this.common.maxStepHeight.get();
    }

    public int getMaxJumpHeight() {
        return (Integer)this.common.maxJumpHeight.get();
    }

    public int getmaxHpBuffer() {
        return (Integer)this.common.hpBufferHearts.get();
    }

    public int getMaxFlightSpeed() {
        return (Integer)this.common.maxFlightSpeed.get();
    }

    public int getEvasionChance() {
        return (Integer)this.common.evasionChance.get();
    }

    public int getMaxMagnetRange() {
        return (Integer)this.common.maxMagnetRange.get();
    }

    public int getStrengthBoost() {
        return (Integer)this.common.strengthBoost.get();
    }

    public int getAttackSpeedBoost() {
        return (Integer)this.common.attackSpeedBoost.get();
    }

    public int getLuckBoost() {
        return (Integer)this.common.luckBoost.get();
    }

    public int getMaxReachBoost() {
        return (Integer)this.common.maxReachBoost.get();
    }

    public int getMaxSwimSpeedBoost() {
        return (Integer)this.common.swimSpeedBoost.get();
    }

    public int getRenegerationPerTick() {
        return (Integer)this.common.regenerationPerTick.get();
    }

    public int getPercentageDamageAbsorption() {
        return (Integer)this.common.percentageDamageAbsorption.get();
    }

    public void save() {
        this.common.spec.save();
        this.client.spec.save();
    }

    public static void register(ModContainer container) {
        if (!container.getModId().equals("advanced_ae")) {
            throw new IllegalArgumentException();
        }
        INSTANCE = new AAEConfig(container);
    }

    public static AAEConfig instance() {
        return INSTANCE;
    }

    private static class ClientConfig {
        private final ModConfigSpec spec;

        public ClientConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.spec = builder.build();
        }
    }

    private static class CommonConfig {
        private final ModConfigSpec spec;
        public final ModConfigSpec.IntValue quantumComputerMaxSize;
        public final ModConfigSpec.IntValue quantumComputerAcceleratorThreads;
        public final ModConfigSpec.IntValue quantumComputerMaxMultiThreaders;
        public final ModConfigSpec.IntValue quantumComputerMaxDataEntanglers;
        public final ModConfigSpec.IntValue quantumComputerMultiThreaderMultiplication;
        public final ModConfigSpec.IntValue quantumComputerDataEntanglerMultiplication;
        public final ModConfigSpec.IntValue maxWalkSpeed;
        public final ModConfigSpec.IntValue maxSprintSpeed;
        public final ModConfigSpec.IntValue maxStepHeight;
        public final ModConfigSpec.IntValue maxJumpHeight;
        public final ModConfigSpec.IntValue hpBufferHearts;
        public final ModConfigSpec.IntValue maxFlightSpeed;
        public final ModConfigSpec.IntValue evasionChance;
        public final ModConfigSpec.IntValue maxMagnetRange;
        public final ModConfigSpec.IntValue strengthBoost;
        public final ModConfigSpec.IntValue attackSpeedBoost;
        public final ModConfigSpec.IntValue luckBoost;
        public final ModConfigSpec.IntValue maxReachBoost;
        public final ModConfigSpec.IntValue swimSpeedBoost;
        public final ModConfigSpec.IntValue regenerationPerTick;
        public final ModConfigSpec.IntValue percentageDamageAbsorption;

        public CommonConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("quantum computer");
            this.quantumComputerMaxSize = CommonConfig.define(builder, "quantumComputerMaxSize", 5, 5, 12, "Define the maximum dimensions of the Quantum Computer Multiblock.");
            this.quantumComputerAcceleratorThreads = CommonConfig.define(builder, "quantumComputerAcceleratorThreads", 8, 4, 16, "Define the maximum amount of multi threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxMultiThreaders = CommonConfig.define(builder, "quantumComputerMaxMultiThreaders", 1, 1, 2, "Define the maximum amount of multi threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxDataEntanglers = CommonConfig.define(builder, "quantumComputermaxDataEntanglers", 1, 1, 2, "Define the maximum amount of Data Entanglers per Quantum Computer Multiblock.");
            this.quantumComputerMultiThreaderMultiplication = CommonConfig.define(builder, "quantumComputerMultiThreaderMultiplication", 4, 2, 8, "Define the multiplication factor of the multi threaders.");
            this.quantumComputerDataEntanglerMultiplication = CommonConfig.define(builder, "quantumComputerDataEntanglerMultiplication", 4, 2, 8, "Define the multiplication factor of the data entanglers.");
            builder.pop();
            builder.push("quantum armor");
            this.maxWalkSpeed = CommonConfig.define(builder, "quantumArmorMaxWalkSpeed", 60, 10, 100, "Define the maximum walk speed increase. Values are divided by 10 before use.");
            this.maxSprintSpeed = CommonConfig.define(builder, "quantumArmorMaxSprintSpeed", 80, 10, 150, "Define the maximum sprint speed increase. Values are divided by 10 before use.");
            this.maxStepHeight = CommonConfig.define(builder, "quantumArmorMaxStepHeight", 3, 1, 5, "Define the maximum increase in step height.");
            this.maxJumpHeight = CommonConfig.define(builder, "quantumArmorMaxJumpHeight", 3, 1, 5, "Define the maximum increase in jump height.");
            this.swimSpeedBoost = CommonConfig.define(builder, "quantumArmorSwimSpeedBoost", 80, 10, 150, "Define the maximum swim speed increase. Values are divided by 10 before use.");
            this.hpBufferHearts = CommonConfig.define(builder, "quantumArmorHpBuffer", 20, 5, 50, "Define the HP increased of the HP Buffer card.");
            this.maxFlightSpeed = CommonConfig.define(builder, "quantumArmorMaxFlightSpeed", 10, 1, 15, "Define the maximum speed boost of the Flight Card.");
            this.evasionChance = CommonConfig.define(builder, "quantumArmorEvasionChance", 30, 0, 100, "Define the evasion % chance of the evasion card.");
            this.maxMagnetRange = CommonConfig.define(builder, "quantumArmorMagnetRange", 12, 5, 15, "Define the max range of the magnet card.");
            this.strengthBoost = CommonConfig.define(builder, "quantumArmorStrengthBoost", 10, 5, 50, "Define the Attack Damage boost of the Strength Card.");
            this.attackSpeedBoost = CommonConfig.define(builder, "quantumArmorAttackSpeedBoost", 5, 1, 10, "Define the Attack Speed Damage boost of the Attack Speed Card.");
            this.luckBoost = CommonConfig.define(builder, "quantumArmorLuckBoost", 2, 1, 5, "Define the luck boost of the Luck Card.");
            this.maxReachBoost = CommonConfig.define(builder, "quantumArmorMaxReachBoost", 5, 1, 8, "Define the max additional reach of the Reach Card.");
            this.regenerationPerTick = CommonConfig.define(builder, "quantumArmorRenegerationPerTick", 10, 1, 20, "Define the amount of hearts regenerated per tick with the Regeneration Card. Value will be divided by 10 before use.");
            this.percentageDamageAbsorption = CommonConfig.define(builder, "quantumArmorPercentageDamageAbsorption", 30, 5, 100, "Define the maximum percentage of incoming damage absorbed by the Quantum Armor. This value is still limited by the energy buffer in the equipment.");
            builder.pop();
            this.spec = builder.build();
        }

        private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, String comment) {
            builder.comment(comment);
            return CommonConfig.define(builder, name, defaultValue);
        }

        private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
            builder.comment(comment);
            return CommonConfig.define(builder, name, defaultValue, min, max);
        }

        private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max) {
            return builder.defineInRange(name, defaultValue, min, max);
        }

        private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue) {
            return CommonConfig.define(builder, name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }
}

