/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;

public class ReactionChamberBlock
extends AEBaseEntityBlock<ReactionChamberEntity> {
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");

    public ReactionChamberBlock() {
        super(ReactionChamberBlock.metalProps().noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReactionChamberEntity) {
            ReactionChamberEntity be = (ReactionChamberEntity)blockEntity;
            if (!level.isClientSide()) {
                MenuOpener.open(AAEMenus.REACTION_CHAMBER, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING});
    }

    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.horizontalFacing();
    }
}

