/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.stacks.AEKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AppEng;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.slot.FakeSlot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;
import net.pedroksl.advanced_ae.client.gui.widgets.NumberTextField;
import net.pedroksl.advanced_ae.gui.QuantumCrafterConfigPatternMenu;
import net.pedroksl.advanced_ae.network.packet.SetStockAmountPacket;

public class QuantumCrafterConfigPatternScreen
extends AEBaseScreen<QuantumCrafterConfigPatternMenu> {
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final int ROW_SPACING = 2;
    private static final int VISIBLE_ROWS = 4;
    private static final int LIST_ANCHOR_X = 18;
    private static final int LIST_ANCHOR_Y = 25;
    private static final int OUTPUT_X = 18;
    private static final int OUTPUT_Y = 110;
    private static final int TEXTFIELD_WIDTH = 60;
    private static final int TEXTFIELD_HEIGHT = 16;
    private static final Rect2i SLOT_BBOX = new Rect2i(176, 0, 18, 18);
    private final ResourceLocation DEFAULT_TEXTURE = AppEng.makeId((String)"textures/guis/pattern_config.png");
    private final Scrollbar scrollbar;
    private final ArrayList<InputRow> rows = new ArrayList();
    private InputRow outputRow;

    public QuantumCrafterConfigPatternScreen(QuantumCrafterConfigPatternMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.SMALL);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int currentRow;
        ((QuantumCrafterConfigPatternMenu)this.menu).slots.removeIf(slot -> slot instanceof FakeSlot);
        this.rows.forEach(row -> {
            if (!this.renderables.contains((Object)row.textField)) {
                this.addRenderableWidget((GuiEventListener)row.textField);
            }
            if (!this.renderables.contains((Object)row.button)) {
                this.addRenderableOnly((Renderable)row.button);
            }
            row.textField.setVisible(false);
        });
        if (!this.renderables.contains((Object)this.outputRow.textField)) {
            this.addRenderableWidget((GuiEventListener)this.outputRow.textField);
        }
        if (!this.renderables.contains((Object)this.outputRow.button)) {
            this.addRenderableOnly((Renderable)this.outputRow.button);
        }
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int visibleRows = Math.min(4, this.rows.size());
        for (int i = 0; i < visibleRows && (currentRow = scrollLevel + i) < this.rows.size(); ++i) {
            int x = 19;
            int y = 26 + i * 20;
            InputRow row2 = this.rows.get(currentRow);
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            renderContext.renderItem(row2.key().wrapForDisplayOrFilter(), x, y, 16.0f, 16.0f);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, row2.label, x += 37, y += 4, 0xFFFFFF);
            row2.textField.setRectangle(60, 16, x += offsetX + 20, y += offsetY);
            row2.textField.setVisible(true);
            row2.button.setValid(!row2.textField.isChanged());
            row2.button.setPosition(x += 70, y -= 5);
        }
        if (this.outputRow != null) {
            int x = 19;
            int y = 111;
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            renderContext.renderItem(this.outputRow.key().wrapForDisplayOrFilter(), x, y, 16.0f, 16.0f);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.outputRow.label, x += 37, y += 4, 0xFFFFFF);
            this.outputRow.textField.setRectangle(60, 16, x += offsetX + 20, y += offsetY);
            this.outputRow.textField.setVisible(true);
            this.outputRow.button.setValid(!this.outputRow.textField.isChanged());
            this.outputRow.button.setPosition(x += 70, y -= 5);
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        int currentX = offsetX + 18;
        int currentY = offsetY + 25;
        int visibleRows = Math.min(4, this.rows.size());
        for (int i = 0; i < visibleRows; ++i) {
            guiGraphics.blit(this.DEFAULT_TEXTURE, currentX, currentY, SLOT_BBOX.getX(), SLOT_BBOX.getY(), SLOT_BBOX.getWidth(), SLOT_BBOX.getHeight());
            currentY += 20;
        }
        guiGraphics.blit(this.DEFAULT_TEXTURE, offsetX + 18, offsetY + 110, SLOT_BBOX.getX(), SLOT_BBOX.getY(), SLOT_BBOX.getWidth(), SLOT_BBOX.getHeight());
    }

    public void update(LinkedHashMap<AEKey, Long> inputs, Pair<AEKey, Long> output) {
        if (inputs.size() != this.rows.size()) {
            this.rows.forEach(row -> this.removeWidget((GuiEventListener)row.textField));
            this.rows.clear();
            for (Map.Entry entry : inputs.entrySet()) {
                NumberTextField textField = this.addNewNumberField((Long)entry.getValue(), this.rows.size());
                this.rows.add(new InputRow((AEKey)entry.getKey(), textField, (Component)Component.empty().append("Keep:"), new ValidButton(btn -> {})));
            }
        } else {
            for (InputRow inputRow : this.rows) {
                inputRow.textField.setFocused(false);
            }
        }
        if (this.outputRow == null) {
            NumberTextField textField = this.addNewNumberField((Long)output.getSecond(), -1);
            this.outputRow = new InputRow((AEKey)output.getFirst(), textField, (Component)Component.empty().append("Limit:"), new ValidButton(btn -> {}));
        } else {
            this.outputRow.textField.setFocused(false);
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(76);
        this.scrollbar.setRange(0, this.rows.size() - 4, 2);
    }

    private NumberTextField addNewNumberField(long value, int index) {
        NumberTextField numberField = new NumberTextField(this.style, 0, 0, 0, 0, amount -> {
            if (index >= 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetStockAmountPacket(index, (long)amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                ((QuantumCrafterConfigPatternMenu)this.menu).setMaxCrafted((long)amount);
            }
        });
        numberField.setLongValue(value);
        if (index == -1) {
            numberField.setAsOutput();
        }
        return numberField;
    }

    public record InputRow(AEKey key, NumberTextField textField, Component label, ValidButton button) {
    }

    static class ValidButton
    extends AAEIconButton {
        private boolean isValid = false;

        public ValidButton(Button.OnPress onPress) {
            super(onPress);
            this.setDisableBackground(true);
            this.setHoverOffsetChange(false);
        }

        public void setValid(boolean val) {
            this.isValid = val;
        }

        @Override
        protected AAEIcon getIcon() {
            return this.isValid ? AAEIcon.VALID_INPUT : AAEIcon.INVALID_INPUT;
        }
    }
}

